/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstring.h" /* <string.h> */

#include "zcontext.h"
#include "zchars.h"
#include "zconfig.h"

/***************************************************************************/
/*                                                                         */
/*  Conf table                                                             */
/*                                                                         */
/***************************************************************************/

int zProcessConfig( struct zcontext_t *cnt, char *line,
    struct zconfdef_t *confTable, unsigned int area, void *data)
{
  struct zconfdef_t *cfg;
  char *name, *value, *s;

  if( (value = strchr( line, '=')) == NULL ) return zpcNoDelimiter;
  *value ++ = '\0';
  while( *value != '\0' && isSpace( *value ) ) value++;
  for( s = value+strlen(value); s > value && isSpace( *(s-1) ); s--) *(s-1) = '\0';
  /* XXX: ??? if( *value == '\0' ) return zpcEmptyValue; */

  for( name = line; *name != '\0' && isSpace( *name ); name++) continue;
  if( *name == '\0' ) return zpcNoKeyword;
  for( s  = name+strlen(name); s > name && isSpace( *(s-1) ); s--) *(s-1) = '\0';
  if( cnt->processConfigString != NULL ) name = cnt->processConfigString( cnt, name);

  for( cfg = confTable; cfg->name != NULL; cfg++)
  {
    if( strcasecmp( name, cfg->name) != 0 ) continue;
    if( (cfg->area & area) == 0 ) return 0;
    if( cfg->getValue != NULL ) return cfg->getValue( cnt, cfg, value, data);
    return zpcOk;
  }

  cnt->errorStrParam = name;
  return zpcUnknownKeyword;
}
