/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstdio.h" /* <stdio.h> */
#include "_pstring.h" /* <string.h> */

#include "zcontext.h"
#include "zchars.h"
#include "zerror.h"
#include "zconfig.h"

/***************************************************************************/
/*                                                                         */
/*  Conf block                                                             */
/*                                                                         */
/***************************************************************************/

static struct zconfsec_t *zFindConfBlock( struct zconfsec_t *list,
    const char *name, unsigned int flags, Boolean *pnotFound)
{
  struct zconfsec_t *cur, *dflt = NULL;

  *pnotFound = False;

  for( cur = list; cur->name != NULL; cur++)
  {
    if( strcasecmp( cur->name, name) == 0 )
      return ((cur->area & flags) == 0) ? NULL : cur;
    if( *cur->name == '\0' && (cur->area & flags) != 0 ) dflt = cur;
  }

  *pnotFound = (dflt == NULL) ? True : False;
  return dflt;
}

Boolean zReadConfFile( struct zcontext_t *cnt, const char *fileName,
    const char *fileAlias, struct zconfsec_t *list, unsigned int flags, void *data)
{
  Boolean wasDirective = False, notFound, success = True;
  char line[512], *ptr, *s;
  struct zconfsec_t *current = NULL;
  FILE *stream;

  if( fileAlias == NULL ) fileAlias = fileName;
  cnt->confLineNumber = 0;
  cnt->confSuccess = True;

  if( (stream = fopen( fileName, READ_T_MODE)) == NULL )
  {
    cnt->printError( cnt, (cnt->confErrors == NULL) ? zerConfFileOpen :
      cnt->confErrors[ZCONFERR_FILE_OPEN], fileAlias);
    return False;
  }

  while( fgets( line, sizeof( line ), stream) != NULL )
  {
    cnt->confLineNumber++;
    for( ptr = line; *ptr != '\0' && isSpace( *ptr ); ptr++) continue;
    if( *ptr == '#' || *ptr == '\0' ) continue;

    if( *ptr == '[' )
    {
      if( current != NULL && current->finish != NULL )
	current->finish( cnt, True, wasDirective, data);
      current = NULL;
      wasDirective = False;
      if( (s = strchr( ++ptr, ']')) == NULL ) continue;
      *s = '\0';
      if( (current = zFindConfBlock( list, ptr, flags, &notFound)) == NULL )
      {
	if( notFound )
          cnt->printError( cnt, (cnt->confErrors == NULL) ? zerConfUnknownSection :
            cnt->confErrors[ZCONFERR_UNKNOWN_SECTION], (cnt->errorStrParam = ptr, fileAlias));
      }
      else
      {
	cnt->confSectionLineNumber = cnt->confLineNumber;
        if( current->init != NULL )
          if( !current->init( cnt, current, flags, fileAlias, data) ) current = NULL;
      }
    }
    else if( current != NULL && current->process != NULL )
    {
      wasDirective = True;
      if( !current->process( cnt, ptr, data) )
      {
        cnt->confSuccess = success = False;
        break;
      }
    }
  }

  if( current != NULL && current->finish != NULL )
    current->finish( cnt, success, wasDirective, data);

  fclose( stream );
  return success;
}

void zFreeConfBlocks( struct zcontext_t *cnt, struct zconfsec_t *list, void *data)
{
  for( ; list->name != NULL; list++)
    if( list->free != NULL ) list->free( cnt, data);
}
