/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstring.h" /* <string.h> */

#include "zcontext.h"
#include "zalloc.h"
#include "zcoll.h"

void zSetCollectionInit( struct zcontext_t *cnt, struct zsetcoll_t *sc,
    unsigned int elemSize, unsigned int delta, unsigned int blockDelta)
{
  ZEROFILL( sc, sizeof(struct zsetcoll_t));
  sc->context = cnt;
  sc->elemSize = elemSize;
  sc->delta = delta;
  sc->blockDelta = blockDelta;
}

void zSetCollectionFree( struct zsetcoll_t *sc, zdelete_t efree)
{
  if( sc->blocks != NULL )
  {
    unsigned int i, bc;

    if( efree != NULL )
      for( i = 0; i < sc->count; i++)
        efree( sc->context, _zSetCollectionElem( sc, i));

    bc = ZCOUNT( sc->count, sc->delta);
    for( i = 0; i < bc; i++) zFree( sc->context, (void *) sc->blocks[i]);

    zFree( sc->context, sc->blocks);
    sc->blocks = NULL;
    sc->count = 0;
  }
}

void *zSetCollectionElem( struct zsetcoll_t *sc, unsigned int num)
{
  if( num >= sc->count ) return NULL;
  return _zSetCollectionElem( sc, num);
}

void *zSetCollectionAdd( struct zsetcoll_t *sc, void *data)
{
  unsigned int bc;
  void *ptr;

  bc = sc->count / sc->delta;

  if( ((sc->count % sc->delta) == 0 && (bc % sc->blockDelta) == 0) )
  {
    unsigned char **blocks;
    if( (blocks = (unsigned char **) zRealloc( sc->context, (void *) sc->blocks,
	  (bc + sc->blockDelta) * sizeof(char *))) == NULL ) return NULL;
    sc->blocks = blocks;
    if( (sc->blocks[bc] = (unsigned char *) zMalloc( sc->context,
           sc->elemSize * sc->delta)) == NULL ) return NULL;
    ptr = sc->blocks[bc];
  }
  else if( (sc->count % sc->delta) == 0 )
  {
    if( (sc->blocks[bc] = (unsigned char *) zMalloc( sc->context,
           sc->elemSize * sc->delta)) == NULL ) return NULL;
    ptr = sc->blocks[bc];
  }
  else
    ptr = _zSetCollectionElem( sc, sc->count);

  memcpy( ptr, data, sc->elemSize);
  sc->context->lastCollectionIndex = sc->count++;
  return ptr;
}

void *zSetCollectionFind( struct zsetcoll_t *sc, const void *elem, zcmp_t cmp)
{
  unsigned int i;
  void *ptr;

  for( i = 0; i < sc->count; i++)
    if( cmp( elem, ptr = _zSetCollectionElem( sc, i)) == 0 )
    {
      sc->context->lastCollectionIndex = i;
      return ptr;
    }

  return NULL;
}
