/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstring.h" /* <string.h> */

#include "zcoll.h"

/***************************************************************************/
/*                                                                         */
/*  Data heap                                                              */
/*                                                                         */
/***************************************************************************/

struct zdataheap_item_t
{
  struct zdataheap_item_t *next;
};

struct zdataheap_block_t
{
  struct zdataheap_block_t *next;
  unsigned int count;
  unsigned int reserved;
};

#define ZDEFAULT_DATAHEAP_BLOCK_SIZE   199

void zDataHeapInit( struct zcontext_t *cnt, struct zdataheap_t *dh,
    unsigned int itemSize, unsigned int delta)
{
  ZEROFILL( dh, sizeof(struct zdataheap_t));
  dh->context = cnt;
  if( (dh->itemSize = itemSize) < sizeof(struct zdataheap_item_t) )
    dh->itemSize = sizeof(struct zdataheap_item_t);
  if( (dh->blockSize = delta) == 0 )
    dh->blockSize = ZDEFAULT_DATAHEAP_BLOCK_SIZE;
}

void zDataHeapFree( struct zdataheap_t *dh )
{
  dh->items = NULL;
  while( dh->blocks != NULL )
  {
    struct zdataheap_block_t *tmp = dh->blocks;
    dh->blocks = tmp->next;
    zFree( dh->context, tmp);
  }
}

void *zDataHeapItemNew( struct zdataheap_t *dh )
{
  struct zdataheap_item_t *item;

  if( dh->items != NULL )
  {
    item = dh->items;
    dh->items = item->next;
  }
  else if( dh->blocks == NULL || dh->blocks->count >= dh->blockSize )
  {
    struct zdataheap_block_t *newBlock = zMalloc( dh->context,
      dh->blockSize * dh->itemSize + sizeof(struct zdataheap_block_t));
    if( newBlock == NULL ) return NULL;
    newBlock->count = 1;
    newBlock->next = dh->blocks;
    dh->blocks = newBlock;
    item = (struct zdataheap_item_t *) &((unsigned char *) newBlock)[
      sizeof(struct zdataheap_block_t)];
  }
  else
  {
    item = (struct zdataheap_item_t *) &((unsigned char *) dh->blocks)[
      sizeof(struct zdataheap_block_t) + dh->blocks->count * dh->itemSize];
    dh->blocks->count++;
  }

  return item;
}

void zDataHeapItemFree( struct zdataheap_t *dh, void *data)
{
  struct zdataheap_item_t *item = (struct zdataheap_item_t *) data;

  item->next = dh->items;
  dh->items = item;
}
