/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"

#include "zcontext.h"
#include "zstring.h"
#include "zcoll.h"

/**************************************************************************/
/*                                                                        */
/*  Param collection                                                      */
/*                                                                        */
/**************************************************************************/

Boolean zParamCollectionInit( struct zcontext_t *cnt, struct zparamcoll_t *pc,
    unsigned int size, unsigned int delta, unsigned int flags,
    unsigned int shift, zstrcmp_t cmpf, zdelete_t efree)
{
  if( !zStringCollectionInit( cnt, (struct zstrcoll_t *) pc, size, delta, flags) ) return False;
  zSetFlags( pc->flags, zcfExtended);

  pc->shift = shift;
  pc->cmp = cmpf;
  pc->efree = efree;

  return True;
}

Boolean zParamCollectionAdd( struct zparamcoll_t *pc, const char *string,
    char *adds, unsigned int addsSize)
{
  return zStringCollectionAdd( (struct zstrcoll_t *) pc,
           zStrdupEx( pc->context, string, adds, addsSize),
           (zcfDontAllocMemory | zcfRejectNullString | zcfFreeIfDuplicate | zcfExtended));
}
