/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"

#include "zcoding.h"

/***************************************************************************/
/*                                                                         */
/*  Encoding                                                               */
/*                                                                         */
/***************************************************************************/

const char * const zCodingBase64Alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

int zCodingBase64Encode( char *dest, const char *src, int length)
{
  char *start = dest;

  while( length > 2 )
  {
    *dest ++ = zCodingBase64Alphabet[(src[0] >> 2) & 0x3f];
    *dest ++ = zCodingBase64Alphabet[((src[0] << 4) & 0x30) | ((src[1] >> 4) & 0x0f)];
    *dest ++ = zCodingBase64Alphabet[((src[1] << 2) & 0x3c) | ((src[2] >> 6) & 0x03)];
    *dest ++ = zCodingBase64Alphabet[src[2] & 0x3f];
    length -= 3;
    src += 3;
  }

  if( length > 0 )
  {
    *dest ++ = zCodingBase64Alphabet[(src[0] >> 2) & 0x3f];
    if( length == 1 )
    {
      *dest ++ = zCodingBase64Alphabet[(src[0] << 4) & 0x30];
      *dest ++ = '=';
    }
    else
    {
      *dest ++ = zCodingBase64Alphabet[((src[0] << 4) & 0x30) | ((src[1] >> 4) & 0x0f)];
      *dest ++ = zCodingBase64Alphabet[((src[1] << 2) & 0x3c)];
    }
    *dest ++ = '=';
  }

  return (int) (dest - start);
}

/***************************************************************************/
/*                                                                         */
/*  Decoding                                                               */
/*                                                                         */
/***************************************************************************/

/* XXX: ᤥ १ ⠡ */
#define DECODE64(x);                    \
    if( (x) >= 'A' && (x) <= 'Z' )      \
      (x) -= 'A';                       \
    else if( (x) >= 'a' && (x) <= 'z' ) \
      (x) -= 'a' - 26;                  \
    else if( (x) >= '0' && (x) <= '9' ) \
      (x) += 52 - '0';                  \
    else if( (x) == '+' )               \
      (x) = 62;                         \
    else if( (x) == '/' )               \
      (x) = 63;                         \
    else                                \
      (x) = -1;

#define DECODE64EX(x,y);                \
    (x) = src[(y)];                     \
    DECODE64(x);                        \
    if( (x) < 0 ){ length = (y); break; }

int zCodingBase64Decode( char *dest, const char *src, int length)
{
  char *start = dest;
  int n0, n1, n2, n3;

  if( length > 3 || length < 0 )
    while( length > 3 || length < 0 )
    {
      DECODE64EX( n0, 0);
      DECODE64EX( n1, 1);
      DECODE64EX( n2, 2);
      DECODE64EX( n3, 3);

      *dest ++ = (char) (((n0 << 2) & 0xfc) | ((n1 >> 4) & 0x03));
      *dest ++ = (char) (((n1 << 4) & 0xf0) | ((n2 >> 2) & 0x0f));
      *dest ++ = (char) (((n2 << 6) & 0xc0) | (n3 & 0x3f));

      if( length > 0 ) length -= 4;
      src += 4;
    }
  else
    do
    {
      if( length > 0 ){ DECODE64EX( n0, 0); }
      if( length > 1 ){ DECODE64EX( n1, 1); }
      if( length > 2 ){ DECODE64EX( n2, 2); }
    } while( 0 );

  if( length > 1 ) *dest ++ = (char) (((n0 << 2) & 0xfc) | ((n1 >> 4) & 0x03));
  if( length > 2 ) *dest ++ = (char) (((n1 << 4) & 0xf0) | ((n2 >> 2) & 0x0f));

  return (int) (dest - start);
}
