/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstring.h" /* <string.h> */

#include "zcharset.h"

int zCharsetByWord( const char *word, const char *pattern, int localCharset)
{
  int csCount = zCharsetCount(), i, j, length;
  const char *table;
  char buf[256];

  if( word == NULL || localCharset < 0 || localCharset >= ZCHARSET_CYR_LAST ||
      csCount <= 0 ) return ZCHARSET_UNKNOWN;
  if( (length = strlen( word )) != (int) strlen( pattern ) || length <= 0 )
      return ZCHARSET_UNKNOWN;
  if( length > sizeof( buf ) ) length = sizeof( buf );

  for( i = 0; i < csCount; i++)
  {
    memcpy( buf, word, length);
    if( (table = any2anyTables[i][localCharset]) != NULL )
      for( j = 0; j < length; j++)
	if( (buf[j] & 0x80) != 0 )
	  buf[j] = table[ (buf[j] & 0x7f) ];
    if( memcmp( buf, pattern, length) == 0 ) return i;
  }

  return ZCHARSET_UNKNOWN;
}
