/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstring.h" /* <string.h> */

#include "zcontext.h"
#include "zcharset.h"

#ifdef RUSSIAN_SUPPORT
void zSetRemoteCharset( struct zcontext_t *cnt, int inCharset, int outCharset)
{
  zUnsetFlags( cnt->ioFlags, ZCONTEXT_IOFLAG_CHARSET_RECODE |
                             ZCONTEXT_IOFLAG_CHARSET_RECODE_STRICT |
                             ZCONTEXT_IOFLAG_CHARSET_CONV);
  cnt->remoteCharset = cnt->remoteStrictCharset = ZCHARSET_UNKNOWN;
  cnt->convTable = cnt->recodeTable = cnt->recodeStrictTable = NULL;
  if( cnt->localCharset < 0 ) return;
  if( inCharset < 0 ) inCharset = outCharset;

  if( zCharsetValid( inCharset ) )
    if( (cnt->convTable = any2anyTables[inCharset][cnt->localCharset]) != NULL )
      zSetFlags( cnt->ioFlags, ZCONTEXT_IOFLAG_CHARSET_CONV);

  if( zCharsetValid( outCharset ) )
  {
    cnt->remoteCharset = cnt->remoteStrictCharset = outCharset;
    if( (cnt->recodeTable = any2anyTables[cnt->localCharset][outCharset]) != NULL )
      zSetFlags( cnt->ioFlags, ZCONTEXT_IOFLAG_CHARSET_RECODE);
    if( (cnt->recodeStrictTable = cnt->recodeTable) != NULL )
      zSetFlags( cnt->ioFlags, ZCONTEXT_IOFLAG_CHARSET_RECODE_STRICT);
  }
}

void zSetRemoteStrictCharset( struct zcontext_t *cnt, int strictCharset)
{
  zUnsetFlags( cnt->ioFlags, ZCONTEXT_IOFLAG_CHARSET_RECODE_STRICT);
  cnt->remoteStrictCharset = ZCHARSET_UNKNOWN;
  cnt->recodeStrictTable = NULL;

  if( zCharsetValid( strictCharset ) )
  {
    cnt->remoteStrictCharset = strictCharset;
    if( (cnt->recodeStrictTable = any2anyTables[cnt->localCharset][strictCharset]) != NULL )
      zSetFlags( cnt->ioFlags, ZCONTEXT_IOFLAG_CHARSET_RECODE_STRICT);
  }

  return;
}
#endif
