/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstring.h" /* <string.h> */

#include "zcharset.h"

struct zgcs_t
{
  int local;
  int global;
};

static const struct zgcs_t globalCharsetTable[] =
{
  { ZCHARSET_CYR_KOI,      ZGCS_RU_KOI },
  { ZCHARSET_CYR_WIN,      ZGCS_RU_WIN },
  { ZCHARSET_CYR_ALT,      ZGCS_RU_ALT },
  { ZCHARSET_CYR_ISO,      ZGCS_RU_ISO },
  { ZCHARSET_CYR_MAC,      ZGCS_RU_MAC },
  { ZCHARSET_UNKNOWN,      ZGCS_NONE   }
};

#define iGlobalCSTable  (sizeof( globalCharsetTable ) / sizeof( gcs_t ) - 1)

int zToGlobalCharset( int localCharset )
{
  const struct zgcs_t *gcs;

  for( gcs = globalCharsetTable; gcs->local != ZCHARSET_UNKNOWN; gcs++)
    if( gcs->local == localCharset ) break;

  return gcs->global;
}

int zToLocalCharset( int globalCharset )
{
  const struct zgcs_t *gcs;

  for( gcs = globalCharsetTable; gcs->local != ZCHARSET_UNKNOWN; gcs++)
    if( gcs->global == globalCharset ) break;

  return gcs->local;
}

Boolean zIsKnownCharset( int globalCharset )
{
  if( globalCharset == 0 ) return True;
  if( globalCharset >= ZGCS_RU_START && globalCharset <= ZGCS_RU_LAST ) return True;
  return False;
}
