/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "_pstring.h" /* <string.h> */

#include "zcharset.h"

struct zcharset_t
{
  int type;
  const char *name;
  unsigned int flags;
};

static struct zcharset_t charsetTable[] =
{
#if defined( UKRAINIAN_SUPPORT ) && defined( APPLY_CYR_KOI8_U_NAME )
  { ZCHARSET_CYR_KOI,        "koi8-u",         ZCHARSET_NAME_OFFICIAL },
#endif
  { ZCHARSET_CYR_KOI,        "koi8-r",         ZCHARSET_NAME_OFFICIAL },
  { ZCHARSET_CYR_KOI,        "koi",            ZCHARSET_NAME_SHORT    },
  { ZCHARSET_CYR_KOI,        "KOI",            ZCHARSET_NAME_SHORTUP  },
  { ZCHARSET_CYR_KOI,        "koi8",           0                      },
  { ZCHARSET_CYR_KOI,        "koi-8",          0                      },
  { ZCHARSET_CYR_KOI,        "koi8r",          0                      },
#ifdef UKRAINIAN_SUPPORT
#if !defined( APPLY_CYR_KOI8_U_NAME )
  { ZCHARSET_CYR_KOI,        "koi8-u",         0                      },
#endif
  { ZCHARSET_CYR_KOI,        "koi8u",          0                      },
#endif
  { ZCHARSET_CYR_WIN,        "windows-1251",   ZCHARSET_NAME_OFFICIAL },
  { ZCHARSET_CYR_WIN,        "win",            ZCHARSET_NAME_SHORT    },
  { ZCHARSET_CYR_WIN,        "WIN",            ZCHARSET_NAME_SHORTUP  },
  { ZCHARSET_CYR_WIN,        "cp1251",         0                      },
  { ZCHARSET_CYR_WIN,        "cp-1251",        0                      },
  { ZCHARSET_CYR_WIN,        "windows",        0                      },
  { ZCHARSET_CYR_ALT,        "ibm866",         ZCHARSET_NAME_OFFICIAL },
  { ZCHARSET_CYR_ALT,        "alt",            ZCHARSET_NAME_SHORT    },
  { ZCHARSET_CYR_ALT,        "ALT",            ZCHARSET_NAME_SHORTUP  },
  { ZCHARSET_CYR_ALT,        "cp866",          0                      },
  { ZCHARSET_CYR_ALT,        "cp-866",         0                      },
  { ZCHARSET_CYR_ALT,        "dos",            0                      },
  { ZCHARSET_CYR_ISO,        "iso-8859-5",     ZCHARSET_NAME_OFFICIAL },
  { ZCHARSET_CYR_ISO,        "iso",            ZCHARSET_NAME_SHORT    },
  { ZCHARSET_CYR_ISO,        "ISO",            ZCHARSET_NAME_SHORTUP  },
  { ZCHARSET_CYR_ISO,        "iso8859-5",      0                      },
  { ZCHARSET_CYR_ISO,        "iso_8859_5",     0                      },
  { ZCHARSET_CYR_ISO,        "iso8859_5",      0                      },
#ifdef APPLY_CYR_SCO
  { ZCHARSET_CYR_ISO,        "sco",            0                      },
  { ZCHARSET_CYR_ISO,        "SCO",            0                      },
#endif
  { ZCHARSET_CYR_MAC,        "x-mac-cyrillic", ZCHARSET_NAME_OFFICIAL },
  { ZCHARSET_CYR_MAC,        "mac",            ZCHARSET_NAME_SHORT    },
  { ZCHARSET_CYR_MAC,        "MAC",            ZCHARSET_NAME_SHORTUP  },
  { ZCHARSET_CYR_TRANS,      "translit",       ZCHARSET_NAME_OFFICIAL },
  { ZCHARSET_CYR_TRANS,      "trans",          ZCHARSET_NAME_SHORT    },
  { ZCHARSET_CYR_TRANS,      "TRANS",          ZCHARSET_NAME_SHORTUP  },
  { ZCHARSET_CYR_TRANS,      "tran",           0                      },
  { ZCHARSET_CYR_TRANS,      "tra",            0                      },
  { ZCHARSET_CYR_TRANS,      "volapuk",        0                      },
  { ZCHARSET_UNKNOWN,        NULL,             0                      }
};

int zCharsetType( const char *name )
{
  struct zcharset_t *cur;

  if( name != NULL ) for( cur = charsetTable; cur->name != NULL; cur++)
    if( strcasecmp( cur->name, name) == 0 ) return cur->type;

  return ZCHARSET_UNKNOWN;
}

const char *zCharsetName( int type, unsigned int flags)
{
  struct zcharset_t *cur;
  const char *name = NULL;

  for( cur = charsetTable; cur->name != NULL; cur++)
    if( cur->type == type )
      if( (cur->flags & flags) != 0 )
        return cur->name;
      else if( name == NULL )
        name = cur->name;

  return name;
}

int zCharsetCount()
{
  return ZCHARSET_CYR_LAST;
}
