/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstring.h"

#include "zchars.h"
#include "zcharset.h"

#ifdef RUSSIAN_SUPPORT
ZDEF(unsigned char) ztSequenceTable[256];
ZDEF(unsigned char) ztFixupTable[256];

void zInitRussians()
{
  register const char *s, *p;
  register int i;
#ifdef UKRAINIAN_SUPPORT
  int charset = LOCAL_CHARSET;
  char *table, c1, c2;

  if( zCharsetValid( charset ) )
    table = win2anyTables[charset];
  else
    table = NULL;
#endif

/* ztCharbitTable */
  for( s = zsUpperRussians; *s != '\0'; s++) setCharbit( *s, CHAR_RUSSIAN_UP);
  for( s = zsLowerRussians; *s != '\0'; s++) setCharbit( *s, CHAR_RUSSIAN_DOWN);
  for( s = zsVowelRussians; *s != '\0'; s++) setCharbit( *s, CHAR_RUSSIAN_VOWEL);
  for( s = zsConsonantRussians; *s != '\0'; s++) setCharbit( *s, CHAR_RUSSIAN_CONSONANT);
  setCharbit( _RUSSIAN_CAPITAL_IO, CHAR_RUSSIAN_UP | CHAR_RUSSIAN_VOWEL);
  setCharbit( _RUSSIAN_SMALL_IO, CHAR_RUSSIAN_DOWN | CHAR_RUSSIAN_VOWEL);

/* ztLowerTable */
  for( s = zsUpperRussians, p = zsLowerRussians; *s != '\0' && *p != '\0'; s++, p++)
    ztLowerTable[ (*s & 0xff) ] = *p;
  ztLowerTable[ (_RUSSIAN_CAPITAL_IO & 0xff) ] = _RUSSIAN_SMALL_E;
  ztLowerTable[ (_RUSSIAN_SMALL_IO & 0xff) ] = _RUSSIAN_SMALL_E;

/* ztUpperTable */
  for( s = zsLowerRussians, p = zsUpperRussians; *s != '\0' && *p != '\0'; s++, p++)
    ztUpperTable[ (*s & 0xff) ] = *p;
  ztUpperTable[ (_RUSSIAN_CAPITAL_IO & 0xff) ] = _RUSSIAN_CAPITAL_E;
  ztUpperTable[ (_RUSSIAN_SMALL_IO & 0xff) ] = _RUSSIAN_CAPITAL_E;

/* ztSequenceTable */
  for( i = 0; i < 256; i++) ztSequenceTable[i] = (char) i;
  for( i = 192, s = zsUpperRussians; *s != '\0' && i < 256; s++, i++)
    ztSequenceTable[ ((*s) & 0xff) ] = (char) i;
  for( i = 224, s = zsLowerRussians; *s != '\0' && i < 256; s++, i++)
    ztSequenceTable[ ((*s) & 0xff) ] = (char) i;
  ztSequenceTable[ (_RUSSIAN_CAPITAL_IO & 0xff) ] = ztSequenceTable[ (_RUSSIAN_CAPITAL_E & 0xff) ];
  ztSequenceTable[ (_RUSSIAN_SMALL_IO & 0xff) ] = ztSequenceTable[ (_RUSSIAN_SMALL_E & 0xff) ];

/* ztFixupTable */
  for( i = 0; i < 256; i++) ztFixupTable[i] = (char) i;
  ztFixupTable[ (_RUSSIAN_CAPITAL_IO & 0xff) ] = (unsigned char) _RUSSIAN_CAPITAL_E;
  ztFixupTable[ (_RUSSIAN_SMALL_IO & 0xff) ] = (unsigned char) _RUSSIAN_SMALL_E;

#ifdef UKRAINIAN_SUPPORT
#define FIX_UKRAINIAN_CHAR(flag,s1,s2);        \
    if( (c1 & 0x80) != 0 && (c2 & 0x80) != 0 ) \
    {                                          \
      setCharbit( c1, CHAR_RUSSIAN_UP | flag); \
      setCharbit( c2, CHAR_RUSSIAN_DOWN | flag); \
      ztLowerTable[ (c1 & 0xff) ] = c2;        \
      ztUpperTable[ (c2 & 0xff) ] = c1;        \
      ztSequenceTable[ (c1 & 0xff) ] = ztSequenceTable[ (s1 & 0xff) ]; \
      ztSequenceTable[ (c2 & 0xff) ] = ztSequenceTable[ (s2 & 0xff) ]; \
    }

  c1 = (table == NULL) ? WIN_UKRAINIAN_CAPITAL_IE : table[ (WIN_UKRAINIAN_CAPITAL_IE & 0x7f) ];
  c2 = (table == NULL) ? WIN_UKRAINIAN_SMALL_IE : table[ (WIN_UKRAINIAN_SMALL_IE & 0x7f) ];
			 /* XXX: ??? CONSONANT */
  FIX_UKRAINIAN_CHAR( CHAR_RUSSIAN_VOWEL, _RUSSIAN_CAPITAL_SI, _RUSSIAN_SMALL_SI);

  c1 = (table == NULL) ? WIN_UKRAINIAN_CAPITAL_BUI : table[ (WIN_UKRAINIAN_CAPITAL_BUI & 0x7f) ];
  c2 = (table == NULL) ? WIN_UKRAINIAN_SMALL_BUI : table[ (WIN_UKRAINIAN_SMALL_BUI & 0x7f) ];
  FIX_UKRAINIAN_CHAR( CHAR_RUSSIAN_VOWEL, _RUSSIAN_CAPITAL_SI, _RUSSIAN_SMALL_SI);

  c1 = (table == NULL) ? WIN_UKRAINIAN_CAPITAL_YI : table[ (WIN_UKRAINIAN_CAPITAL_YI & 0x7f) ];
  c2 = (table == NULL) ? WIN_UKRAINIAN_SMALL_YI : table[ (WIN_UKRAINIAN_SMALL_YI & 0x7f) ];
                       /* XXX: ??? VOWEL */
  FIX_UKRAINIAN_CHAR( CHAR_RUSSIAN_CONSONANT, _RUSSIAN_CAPITAL_SI, _RUSSIAN_SMALL_SI);

  c1 = (table == NULL) ? WIN_UKRAINIAN_CAPITAL_SU : table[ (WIN_UKRAINIAN_CAPITAL_SU & 0x7f) ];
  c2 = (table == NULL) ? WIN_UKRAINIAN_SMALL_SU : table[ (WIN_UKRAINIAN_SMALL_SU & 0x7f) ];
                       /* XXX: ??? CONSONANT */
  FIX_UKRAINIAN_CHAR( CHAR_RUSSIAN_VOWEL, _RUSSIAN_CAPITAL_U, _RUSSIAN_SMALL_U);

  c1 = (table == NULL) ? WIN_UKRAINIAN_CAPITAL_UGHE : table[ (WIN_UKRAINIAN_CAPITAL_UGHE & 0x7f) ];
  c2 = (table == NULL) ? WIN_UKRAINIAN_SMALL_UGHE : table[ (WIN_UKRAINIAN_SMALL_UGHE & 0x7f) ];
                       /* XXX: ??? VOWEL */              /* XXX: ??? */
  FIX_UKRAINIAN_CHAR( CHAR_RUSSIAN_CONSONANT, _RUSSIAN_CAPITAL_U, _RUSSIAN_SMALL_U);
#endif
}
#endif
