/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "zchars.h"

/***************************************************************************/
/*                                                                         */
/*  The table of char bits                                                 */
/*                                                                         */
/***************************************************************************/

ZDEF(unsigned zint_t) ztCharbitTable[256] =
{
  /*       0 */  CHAR_CONTROL,
  /*       1 */  CHAR_CONTROL,
  /*       2 */  CHAR_CONTROL,
  /*       3 */  CHAR_CONTROL,
  /*       4 */  CHAR_CONTROL,
  /*       5 */  CHAR_CONTROL,
  /*       6 */  CHAR_CONTROL,
  /*       7 */  CHAR_CONTROL,
  /*       8 */  CHAR_CONTROL,
  /*       9 */  CHAR_SPACE | CHAR_CONTROL | CHAR_INLINE_SPACE,
  /*      10 */  CHAR_SPACE | CHAR_CONTROL,
  /*      11 */  CHAR_SPACE | CHAR_CONTROL,
  /*      12 */  CHAR_SPACE | CHAR_CONTROL,
  /*      13 */  CHAR_SPACE | CHAR_CONTROL,
  /*      14 */  CHAR_CONTROL,
  /*      15 */  CHAR_CONTROL,
  /*      16 */  CHAR_CONTROL,
  /*      17 */  CHAR_CONTROL,
  /*      18 */  CHAR_CONTROL,
  /*      19 */  CHAR_CONTROL,
  /*      20 */  CHAR_CONTROL,
  /*      21 */  CHAR_CONTROL,
  /*      22 */  CHAR_CONTROL,
  /*      23 */  CHAR_CONTROL,
  /*      24 */  CHAR_CONTROL,
  /*      25 */  CHAR_CONTROL,
  /*      26 */  CHAR_CONTROL,
  /*      27 */  CHAR_CONTROL,
  /*      28 */  CHAR_CONTROL,
  /*      29 */  CHAR_CONTROL,
  /*      30 */  CHAR_CONTROL,
  /*      31 */  CHAR_CONTROL,
  /* ' '  32 */  CHAR_SPACE | CHAR_INLINE_SPACE,
  /* '!'  33 */  CHAR_PUNCT,
  /* '"'  34 */  CHAR_PUNCT | CHAR_URLSPEC,
  /* '#'  35 */  CHAR_PUNCT | CHAR_URLSPEC,
  /* '$'  36 */  CHAR_PUNCT,
  /* '%'  37 */  CHAR_PUNCT | CHAR_URLSPEC,
  /* '&'  38 */  CHAR_PUNCT | CHAR_URLSPEC,
  /* '\'' 39 */  CHAR_PUNCT,
  /* '('  40 */  CHAR_PUNCT,
  /* ')'  41 */  CHAR_PUNCT,
  /* '*'  42 */  CHAR_PUNCT,
  /* '+'  43 */  CHAR_PUNCT | CHAR_URLSPEC,
  /* ','  44 */  CHAR_PUNCT,
  /* '-'  45 */  CHAR_PUNCT,
  /* '.'  46 */  CHAR_PUNCT,
  /* '/'  47 */  CHAR_PUNCT,
  /* '0'  48 */  CHAR_DIGIT | CHAR_XDIGIT,
  /* '1'  49 */  CHAR_DIGIT | CHAR_XDIGIT,
  /* '2'  50 */  CHAR_DIGIT | CHAR_XDIGIT,
  /* '3'  51 */  CHAR_DIGIT | CHAR_XDIGIT,
  /* '4'  52 */  CHAR_DIGIT | CHAR_XDIGIT,
  /* '5'  53 */  CHAR_DIGIT | CHAR_XDIGIT,
  /* '6'  54 */  CHAR_DIGIT | CHAR_XDIGIT,
  /* '7'  55 */  CHAR_DIGIT | CHAR_XDIGIT,
  /* '8'  56 */  CHAR_DIGIT | CHAR_XDIGIT,
  /* '9'  57 */  CHAR_DIGIT | CHAR_XDIGIT,
  /* ':'  58 */  CHAR_PUNCT | CHAR_URLSPEC,
  /* ';'  59 */  CHAR_PUNCT | CHAR_URLSPEC,
  /* '<'  60 */  CHAR_PUNCT | CHAR_URLSPEC,
  /* '='  61 */  CHAR_PUNCT | CHAR_URLSPEC,
  /* '>'  62 */  CHAR_PUNCT | CHAR_URLSPEC,
  /* '?'  63 */  CHAR_PUNCT | CHAR_URLSPEC,
  /* '@'  64 */  CHAR_PUNCT | CHAR_URLSPEC,
  /* 'A'  65 */  CHAR_ENGLISH_UP | CHAR_XDIGIT | CHAR_ENGLISH_VOWEL,
  /* 'B'  66 */  CHAR_ENGLISH_UP | CHAR_XDIGIT | CHAR_ENGLISH_CONSONANT,
  /* 'C'  67 */  CHAR_ENGLISH_UP | CHAR_XDIGIT | CHAR_ENGLISH_CONSONANT,
  /* 'D'  68 */  CHAR_ENGLISH_UP | CHAR_XDIGIT | CHAR_ENGLISH_CONSONANT,
  /* 'E'  69 */  CHAR_ENGLISH_UP | CHAR_XDIGIT | CHAR_ENGLISH_VOWEL,
  /* 'F'  70 */  CHAR_ENGLISH_UP | CHAR_XDIGIT,
  /* 'G'  71 */  CHAR_ENGLISH_UP | CHAR_ENGLISH_CONSONANT,
  /* 'H'  72 */  CHAR_ENGLISH_UP | CHAR_ENGLISH_CONSONANT,
  /* 'I'  73 */  CHAR_ENGLISH_UP | CHAR_ENGLISH_VOWEL,
  /* 'J'  74 */  CHAR_ENGLISH_UP,
  /* 'K'  75 */  CHAR_ENGLISH_UP | CHAR_ENGLISH_CONSONANT,
  /* 'L'  76 */  CHAR_ENGLISH_UP | CHAR_ENGLISH_CONSONANT,
  /* 'M'  77 */  CHAR_ENGLISH_UP | CHAR_ENGLISH_CONSONANT,
  /* 'N'  78 */  CHAR_ENGLISH_UP | CHAR_ENGLISH_CONSONANT,
  /* 'O'  79 */  CHAR_ENGLISH_UP | CHAR_ENGLISH_VOWEL,
  /* 'P'  80 */  CHAR_ENGLISH_UP | CHAR_ENGLISH_CONSONANT,
  /* 'Q'  81 */  CHAR_ENGLISH_UP | CHAR_ENGLISH_CONSONANT,
  /* 'R'  82 */  CHAR_ENGLISH_UP | CHAR_ENGLISH_CONSONANT,
  /* 'S'  83 */  CHAR_ENGLISH_UP | CHAR_ENGLISH_CONSONANT,
  /* 'T'  84 */  CHAR_ENGLISH_UP | CHAR_ENGLISH_CONSONANT,
  /* 'U'  85 */  CHAR_ENGLISH_UP | CHAR_ENGLISH_VOWEL,
  /* 'V'  86 */  CHAR_ENGLISH_UP | CHAR_ENGLISH_CONSONANT,
  /* 'W'  87 */  CHAR_ENGLISH_UP | CHAR_ENGLISH_CONSONANT,
  /* 'X'  88 */  CHAR_ENGLISH_UP | CHAR_ENGLISH_CONSONANT,
  /* 'Y'  89 */  CHAR_ENGLISH_UP | CHAR_ENGLISH_CONSONANT,
  /* 'Z'  90 */  CHAR_ENGLISH_UP | CHAR_ENGLISH_CONSONANT,
  /* '['  91 */  CHAR_PUNCT,
  /* '\\' 92 */  CHAR_PUNCT,
  /* ']'  93 */  CHAR_PUNCT,
  /* '^'  94 */  CHAR_PUNCT,
  /* '_'  95 */  CHAR_PUNCT,
  /* '`'  96 */  CHAR_PUNCT,
  /* 'a'  97 */  CHAR_ENGLISH_DOWN | CHAR_XDIGIT | CHAR_ENGLISH_VOWEL,
  /* 'b'  98 */  CHAR_ENGLISH_DOWN | CHAR_XDIGIT | CHAR_ENGLISH_CONSONANT,
  /* 'c'  99 */  CHAR_ENGLISH_DOWN | CHAR_XDIGIT | CHAR_ENGLISH_CONSONANT,
  /* 'd' 100 */  CHAR_ENGLISH_DOWN | CHAR_XDIGIT | CHAR_ENGLISH_CONSONANT,
  /* 'e' 101 */  CHAR_ENGLISH_DOWN | CHAR_XDIGIT | CHAR_ENGLISH_VOWEL,
  /* 'f' 102 */  CHAR_ENGLISH_DOWN | CHAR_XDIGIT | CHAR_ENGLISH_CONSONANT,
  /* 'g' 103 */  CHAR_ENGLISH_DOWN | CHAR_ENGLISH_CONSONANT,
  /* 'h' 104 */  CHAR_ENGLISH_DOWN | CHAR_ENGLISH_CONSONANT,
  /* 'i' 105 */  CHAR_ENGLISH_DOWN | CHAR_ENGLISH_VOWEL,
  /* 'j' 106 */  CHAR_ENGLISH_DOWN | CHAR_ENGLISH_CONSONANT,
  /* 'k' 107 */  CHAR_ENGLISH_DOWN | CHAR_ENGLISH_CONSONANT,
  /* 'l' 108 */  CHAR_ENGLISH_DOWN | CHAR_ENGLISH_CONSONANT,
  /* 'm' 109 */  CHAR_ENGLISH_DOWN | CHAR_ENGLISH_CONSONANT,
  /* 'n' 110 */  CHAR_ENGLISH_DOWN | CHAR_ENGLISH_CONSONANT,
  /* 'o' 111 */  CHAR_ENGLISH_DOWN | CHAR_ENGLISH_VOWEL,
  /* 'p' 112 */  CHAR_ENGLISH_DOWN | CHAR_ENGLISH_CONSONANT,
  /* 'q' 113 */  CHAR_ENGLISH_DOWN | CHAR_ENGLISH_CONSONANT,
  /* 'r' 114 */  CHAR_ENGLISH_DOWN | CHAR_ENGLISH_CONSONANT,
  /* 's' 115 */  CHAR_ENGLISH_DOWN | CHAR_ENGLISH_CONSONANT,
  /* 't' 116 */  CHAR_ENGLISH_DOWN | CHAR_ENGLISH_CONSONANT,
  /* 'u' 117 */  CHAR_ENGLISH_DOWN | CHAR_ENGLISH_VOWEL,
  /* 'v' 118 */  CHAR_ENGLISH_DOWN | CHAR_ENGLISH_CONSONANT,
  /* 'w' 119 */  CHAR_ENGLISH_DOWN | CHAR_ENGLISH_CONSONANT,
  /* 'x' 120 */  CHAR_ENGLISH_DOWN | CHAR_ENGLISH_CONSONANT,
  /* 'y' 121 */  CHAR_ENGLISH_DOWN | CHAR_ENGLISH_CONSONANT,
  /* 'z' 122 */  CHAR_ENGLISH_DOWN | CHAR_ENGLISH_CONSONANT,
  /* '{' 123 */  CHAR_PUNCT,
  /* '|' 124 */  CHAR_PUNCT,
  /* '}' 125 */  CHAR_PUNCT,
  /* '~' 126 */  CHAR_PUNCT,
  /* '' 127 */  CHAR_CONTROL,
  /*     128 */  0,
  /*     129 */  0,
  /*     130 */  0,
  /*     131 */  0,
  /*     132 */  0,
  /*     133 */  0,
  /*     134 */  0,
  /*     135 */  0,
  /*     136 */  0,
  /*     137 */  0,
  /*     138 */  0,
  /*     139 */  0,
  /*     140 */  0,
  /*     141 */  0,
  /*     142 */  0,
  /*     143 */  0,
  /*     144 */  0,
  /*     145 */  0,
  /*     146 */  0,
  /*     147 */  0,
  /*     148 */  0,
  /*     149 */  0,
  /*     150 */  0,
  /*     151 */  0,
  /*     152 */  0,
  /*     153 */  0,
  /*     154 */  0,
  /*     155 */  0,
  /*     156 */  0,
  /*     157 */  0,
  /*     158 */  0,
  /*     159 */  0,
  /*     160 */  0,
  /*     161 */  0,
  /*     162 */  0,
  /*     163 */  0,
  /*     164 */  0,
  /*     165 */  0,
  /*     166 */  0,
  /*     167 */  0,
  /*     168 */  0,
  /*     169 */  0,
  /*     170 */  0,
  /*     171 */  0,
  /*     172 */  0,
  /*     173 */  0,
  /*     174 */  0,
  /*     175 */  0,
  /*     176 */  0,
  /*     177 */  0,
  /*     178 */  0,
  /*     179 */  0,
  /*     180 */  0,
  /*     181 */  0,
  /*     182 */  0,
  /*     183 */  0,
  /*     184 */  0,
  /*     185 */  0,
  /*     186 */  0,
  /*     187 */  0,
  /*     188 */  0,
  /*     189 */  0,
  /*     190 */  0,
  /*     191 */  0,
  /*     192 */  0,
  /*     193 */  0,
  /*     194 */  0,
  /*     195 */  0,
  /*     196 */  0,
  /*     197 */  0,
  /*     198 */  0,
  /*     199 */  0,
  /*     200 */  0,
  /*     201 */  0,
  /*     202 */  0,
  /*     203 */  0,
  /*     204 */  0,
  /*     205 */  0,
  /*     206 */  0,
  /*     207 */  0,
  /*     208 */  0,
  /*     209 */  0,
  /*     210 */  0,
  /*     211 */  0,
  /*     212 */  0,
  /*     213 */  0,
  /*     214 */  0,
  /*     215 */  0,
  /*     216 */  0,
  /*     217 */  0,
  /*     218 */  0,
  /*     219 */  0,
  /*     220 */  0,
  /*     221 */  0,
  /*     222 */  0,
  /*     223 */  0,
  /*     224 */  0,
  /*     225 */  0,
  /*     226 */  0,
  /*     227 */  0,
  /*     228 */  0,
  /*     229 */  0,
  /*     230 */  0,
  /*     231 */  0,
  /*     232 */  0,
  /*     233 */  0,
  /*     234 */  0,
  /*     235 */  0,
  /*     236 */  0,
  /*     237 */  0,
  /*     238 */  0,
  /*     239 */  0,
  /*     240 */  0,
  /*     241 */  0,
  /*     242 */  0,
  /*     243 */  0,
  /*     244 */  0,
  /*     245 */  0,
  /*     246 */  0,
  /*     247 */  0,
  /*     248 */  0,
  /*     249 */  0,
  /*     250 */  0,
  /*     251 */  0,
  /*     252 */  0,
  /*     253 */  0,
  /*     254 */  0,
  /*     255 */  0
};

