/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstring.h" /* <string.h> */

#include "zcontext.h"
#include "zalloc.h"

#if defined( ZCHECK_SYSTEM_ALLOCATIONS )
ZFUN(char *) zchkStrdupEx( struct zcontext_t *cnt, const char *string, const char *adds, unsigned int addsSize,
    char *fileName, int lineNumber)
#else
ZFUN(char *) zStrdupEx( struct zcontext_t *cnt, const char *string, const char *adds, unsigned int addsSize)
#endif
{
  unsigned int length = strlen( string );
#if defined( ZCHECK_SYSTEM_ALLOCATIONS )
  char *newString = zchkMalloc( cnt, cnt->lastStringSize = length + addsSize + 1, fileName, lineNumber);
#else
  char *newString = zMalloc( cnt, cnt->lastStringSize = length + addsSize + 1);
#endif

  if( newString != NULL )
  {
    if( addsSize != 0 ) memcpy( newString, adds, addsSize);
    memcpy( &newString[addsSize], string, length + 1);
  }

  return newString;
}

#if defined( ZCHECK_SYSTEM_ALLOCATIONS )
ZFUN(char *) zchkSubStrdup( struct zcontext_t *cnt, const char *begin, const char *end,
    char *fileName, int lineNumber)
#else
ZFUN(char *) zSubStrdup( struct zcontext_t *cnt, const char *begin, const char *end)
#endif
{
  unsigned int length = (end == NULL) ? strlen( begin ) : (int) (end - begin);
#if defined( ZCHECK_SYSTEM_ALLOCATIONS )
  char *ptr = (char *) zchkMalloc( cnt, cnt->lastStringSize = length + 1, fileName, lineNumber);
#else
  char *ptr = (char *) zMalloc( cnt, cnt->lastStringSize = length + 1);
#endif

  if( ptr != NULL )
  {
    memcpy( ptr, begin, length);
    ptr[length] = '\0';
  }

  return ptr;
}
