/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstring.h" /* <string.h> */

#include "zcontext.h"
#include "zalloc.h"

#if defined( ZCHECK_SYSTEM_ALLOCATIONS )
ZFUN(char *) zchkStrdup( struct zcontext_t *cnt, const char *s,
    char *fileName, int lineNumber)
#else
ZFUN(char *) zStrdup( struct zcontext_t *cnt, const char *s)
#endif
{
  if( *s == '\0' )
  {
    cnt->lastStringSize = 1;
    return (char *) zDummyString;
  }
  else
  {
#if defined( ZCHECK_SYSTEM_ALLOCATIONS )
    char *p = (char *) zchkMalloc( cnt, cnt->lastStringSize = strlen( s ) + 1, fileName, lineNumber);
#else
    char *p = (char *) zMalloc( cnt, cnt->lastStringSize = strlen( s ) + 1);
#endif
    if( p != NULL ) strcpy( p, s);
    return p;
  }
}

#if defined( ZCHECK_SYSTEM_ALLOCATIONS )
ZFUN(char *) zchkStrndup( struct zcontext_t *cnt, const char *s, unsigned int length,
    char *fileName, int lineNumber)
#else
ZFUN(char *) zStrndup( struct zcontext_t *cnt, const char *s, unsigned int length)
#endif
{
  if( *s == '\0' || length == 0 )
  {
    cnt->lastStringSize = 1;
    return (char *) zDummyString;
  }
  else
  {
    const char *ptr = memchr( s, '\0', length);
    unsigned int l = (ptr == NULL) ? length : (unsigned int) (ptr - s);
#if defined( ZCHECK_SYSTEM_ALLOCATIONS )
    char *p = (char *) zchkMalloc( cnt, cnt->lastStringSize = l + 1, fileName, lineNumber);
#else
    char *p = (char *) zMalloc( cnt, cnt->lastStringSize = l + 1);
#endif
    if( p != NULL ){ strncpy( p, s, l); p[l] = '\0'; }
    return p;
  }
}

#if defined( ZCHECK_SYSTEM_ALLOCATIONS )
ZFUN(void *) zchkMemdup( struct zcontext_t *cnt, const void *m, unsigned int length,
    char *fileName, int lineNumber)
#else
ZFUN(void *) zMemdup( struct zcontext_t *cnt, const void *m, unsigned int length)
#endif
{
  if( length == 0 )
    return (void *) zDummyString;
  else
  {
#if defined( ZCHECK_SYSTEM_ALLOCATIONS )
    char *p = (char *) zchkMalloc( cnt, length, fileName, lineNumber);
#else
    char *p = (char *) zMalloc( cnt, length);
#endif
    if( p != NULL ) memcpy( p, m, length);
    return p;
  }
}
