/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstring.h" /* <string.h> */
#include <stdlib.h>
#include <limits.h>

#include "zcontext.h"
#include "zerror.h"
#include "zalloc.h"

#if defined( ZCHECK_SYSTEM_ALLOCATIONS )
void *zchkCalloc( struct zcontext_t *cnt, unsigned int nmemb, size_t size, Boolean zero,
    char *fileName, int lineNumber)
#else
void *zCalloc( struct zcontext_t *cnt, unsigned int nmemb, size_t size, Boolean zero)
#endif
{
  void *ptr;

  if( size == 0 || nmemb == 0 ) return (void *) zDummyString;

  if( nmemb > (UINT_MAX / size) )
  {
    if( cnt->allocFail != NULL ) cnt->allocFail( cnt, "zCalloc");
    return NULL;
  }

  size *= nmemb;
#if defined( ZCHECK_SYSTEM_ALLOCATIONS )
  if( (ptr = zchkMalloc( cnt, size, fileName, lineNumber)) == NULL ) return NULL;
#else
  if( (ptr = zMalloc( cnt, size)) == NULL ) return NULL;
#endif

  if( zero ) ZEROFILL( (char *) ptr, size);
  return ptr;
}

#if defined( ZCHECK_SYSTEM_ALLOCATIONS )
void *zchkRecalloc( struct zcontext_t *cnt, void *ptr, unsigned int nmemb, size_t size,
    char *fileName, int lineNumber)
#else
void *zRecalloc( struct zcontext_t *cnt, void *ptr, unsigned int nmemb, size_t size)
#endif
{
  if( size == 0 || nmemb == 0 ) return (void *) zDummyString;

  if( nmemb > (UINT_MAX / size) )
  {
    if( cnt->allocFail != NULL ) cnt->allocFail( cnt, "zRecalloc");
    return NULL;
  }

  size *= nmemb;
#if defined( ZCHECK_SYSTEM_ALLOCATIONS )
  return zchkRealloc( cnt, ptr, size, fileName, lineNumber);
#else
  return zRealloc( cnt, ptr, size);
#endif
}
