/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstring.h" /* <string.h> */
#if defined( __MSVC__ )
#include "_pwin.h" /* <windows.h> */
#endif
#if defined( ZCHECK )
#include <assert.h>
#endif
#if defined( ZCHECK_SYSTEM_ALLOCATIONS )
#if !defined( ZCHECK )
#include <assert.h>
#endif
#if defined( __BC__ )
#include <alloc.h>
#endif
#endif

#include "zcontext.h"
#include "zerror.h"
#if defined( ZCHECK_SYSTEM_ALLOCATIONS )
#include "zstdio.h"
#endif
#include "zalloc.h"

ZDEF(const char * const) zDummyString = "";

#if defined( ZCHECK_SYSTEM_ALLOCATIONS )
ZFUN(void *) zchkMalloc( struct zcontext_t *cnt, size_t size,
    char *fileName, int lineNumber)
#else
ZFUN(void *) zMalloc( struct zcontext_t *cnt, size_t size)
#endif
{
  void *ptr;

#if defined( ZCHECK_SYSTEM_ALLOCATIONS )
#if defined( __BC__ )
  zflush( cnt );
  if( heapcheck() < 0 )
    __assertfail( "Heap corrupted (detected in the %s of zMalloc), file %s, line %d\n",
      "start", fileName, lineNumber);
#elif defined( __MSVC__ )
  zflush( cnt );
  if( !HeapValidate( (cnt->hHeap != (unsigned long) NULL) ? 
        (HANDLE) cnt->hHeap : GetProcessHeap(), 0, NULL) )
    _assert( "Heap corrupted (detected int the start of zMalloc)", fileName, lineNumber);
#endif
#endif

#if defined( __MSVC__ )
  if( cnt->hHeap != (unsigned long) NULL )
    ptr = HeapAlloc( (HANDLE) cnt->hHeap, 0, size);
  else
#endif
    ptr = malloc( size );

#if defined( ZCHECK_SYSTEM_ALLOCATIONS )
#if defined( __BC__ )
  zflush( cnt );
  if( heapcheck() < 0 )
    __assertfail( "Heap corrupted (detected in the %s of zMalloc), file %s, line %d\n",
      "end", fileName, lineNumber);
#elif defined( __MSVC__ )
  zflush( cnt );
  if( !HeapValidate( (cnt->hHeap != (unsigned long) NULL) ? 
        (HANDLE) cnt->hHeap : GetProcessHeap(), 0, NULL) )
    _assert( "Heap corrupted (detected int the end of zMalloc)", fileName, lineNumber);
#endif
#endif

  if( ptr == NULL )
  {
    if( cnt->allocFail != NULL ) cnt->allocFail( cnt, "malloc");
    cnt->errorCode = zerNoMemory;
  }
#if defined( ZCHECK_MEMORY_ALLOCATIONS )
  else
    cnt->allocCount++;
#endif

  return ptr;
}

#if defined( ZCHECK_SYSTEM_ALLOCATIONS )
ZFUN(void *) zchkRealloc( struct zcontext_t *cnt, void *ptr, size_t size,
    char *fileName, int lineNumber)
#else
ZFUN(void *) zRealloc( struct zcontext_t *cnt, void *ptr, size_t size)
#endif
{
#ifdef ZCHECK
  assert( size > 0 );
#endif

  if( ptr == NULL || ptr == zDummyString )
#if defined( ZCHECK_SYSTEM_ALLOCATIONS )
    return zchkMalloc( cnt, size, fileName, lineNumber);
#else
    return zMalloc( cnt, size);
#endif

#if defined( ZCHECK_SYSTEM_ALLOCATIONS )
#if defined( __BC__ )
  zflush( cnt );
  if( heapcheck() < 0 )
    __assertfail( "Heap corrupted (detected in the %s of zRealloc), file %s, line %d\n",
      "start", fileName, lineNumber);
#elif defined( __MSVC__ )
  zflush( cnt );
  if( !HeapValidate( (cnt->hHeap != (unsigned long) NULL) ? 
        (HANDLE) cnt->hHeap : GetProcessHeap(), 0, NULL) )
    _assert( "Heap corrupted (detected int the start of zRealloc)", fileName, lineNumber);
#endif
#endif

#if defined( __MSVC__ )
  if( cnt->hHeap != (unsigned long) NULL )
    ptr = HeapReAlloc( (HANDLE) cnt->hHeap, 0, ptr, size);
  else
#endif
    ptr = realloc( ptr, size);

#if defined( ZCHECK_SYSTEM_ALLOCATIONS )
#if defined( __BC__ )
  zflush( cnt );
  if( heapcheck() < 0 )
    __assertfail( "Heap corrupted (detected in the %s of zRealloc), file %s, line %d\n",
      "end", fileName, lineNumber);
#elif defined( __MSVC__ )
  zflush( cnt );
  if( !HeapValidate( (cnt->hHeap != (unsigned long) NULL) ? 
        (HANDLE) cnt->hHeap : GetProcessHeap(), 0, NULL) )
    _assert( "Heap corrupted (detected int the end of zRealloc)", fileName, lineNumber);
#endif
#endif

  if( ptr == NULL )
  {
    if( cnt->allocFail != NULL ) cnt->allocFail( cnt, "realloc");
    cnt->errorCode = zerNoMemory;
  }

  return ptr;
}

#if defined( ZCHECK_SYSTEM_ALLOCATIONS )
ZFUN(void) zchkFree( struct zcontext_t *cnt, const void *ptr,
    char *fileName, int lineNumber)
#else
ZFUN(void) zFree( struct zcontext_t *cnt, const void *ptr)
#endif
{
#ifdef ZCHECK
  assert( ptr != NULL );
#endif

  if( ptr != zDummyString )
  {
#if defined( ZCHECK_SYSTEM_ALLOCATIONS )
#if defined( __BC__ )
    zflush( cnt );
    if( heapcheck() < 0 )
      __assertfail( "Heap corrupted (detected in the %s of zFree), file %s, line %d\n",
        "start", fileName, lineNumber);
#elif defined( __MSVC__ )
    zflush( cnt );
    if( !HeapValidate( (cnt->hHeap != (unsigned long) NULL) ? 
          (HANDLE) cnt->hHeap : GetProcessHeap(), 0, NULL) )
      _assert( "Heap corrupted (detected int the start of zFree)", fileName, lineNumber);
#endif
#endif

#if defined( __MSVC__ )
  if( cnt->hHeap != (unsigned long) NULL )
    HeapFree( (HANDLE) cnt->hHeap, 0, (void *) ptr);
  else
#endif
    free( (void *) ptr );

#if defined( ZCHECK_SYSTEM_ALLOCATIONS )
#if defined( __BC__ )
    zflush( cnt );
    if( heapcheck() < 0 )
      __assertfail( "Heap corrupted (detected in the %s of zFree), file %s, line %d\n",
        "end", fileName, lineNumber);
#elif defined( __MSVC__ )
    zflush( cnt );
    if( !HeapValidate( (cnt->hHeap != (unsigned long) NULL) ? 
          (HANDLE) cnt->hHeap : GetProcessHeap(), 0, NULL) )
      _assert( "Heap corrupted (detected in the end of zFree)", fileName, lineNumber);
#endif
#endif

#if defined( ZCHECK_MEMORY_ALLOCATIONS )
    cnt->allocCount--;
#endif
  }
}
