/* This file should be included instead of <string.h> or <strings.h>. */

#ifndef ___PSTRING_A
#define ___PSTRING_A

#ifndef __ZDEFS_A
#include "zdefs.h"
#endif

/* Decide which flavor of the header file describing the C library
   string functions to include and include it. */

#if defined( HAVE_STRING_H )
#include <string.h>
#elif defined( HAVE_STRINGS_H )
#include <strings.h>
#endif

/*  This is needed for the definitions of memcpy... on solaris */
#if defined( HAVE_MEMORY_H ) && !defined( __cplusplus )
#include <memory.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

#if defined( HAVE_BZERO ) || defined( bzero )
#define ZEROFILL(x,y)  bzero( x, y)
#elif defined( HAVE_MEMSET ) || defined( memset )
#define ZEROFILL(x,y)  memset( x, '\0', y)
#elif defined( HAVE_BFILL ) || defined( bfill )
#define ZEROFILL(x,y)  bfill( x, y, '\0')
#else
#define ZEROFILL(x,y)  _bsd_bzero( x, y)
void _bsd_bzero( void *dst0, register size_t length);
#endif

#if defined( BROKEN_MEMCMP ) || (!defined( HAVE_MEMCMP ) && !defined( memcmp ))
#if defined( HAVE_BCMP )
#define memcmp(a,b,n)  bcmp(a,b,n)
#else
#define memcmp(a,b,n)  _bsd_memcmp(a,b,n)
int _bsd_memcmp( const void *s1, const void *s2, size_t n);
#endif
#endif

#if !defined( HAVE_MEMCPY ) && !defined( memcpy )
#if defined( HAVE_MEMMOVE ) || defined( memmove )
#define memcpy(x,y,z)  memmove(x,y,z)
#elif defined( HAVE_BCOPY ) || defined( bcopy )
#define memcpy(x,y,z)  bcopy(y,x,z)
#elif defined( HAVE_BMOVE ) || defined( bmove )
#define memcpy(x,y,z)  bmove(y,x,z)
#else
#define memcpy(x,y,z)  _bsd_memmove(x,y,z)
void *_bsd_memmove( void *dst0, const void *src0, register size_t length);
#define _HAVE_BSD_MEMMOVE_PROTOTYPE
#endif
#endif

#if !defined( HAVE_MEMMOVE ) && !defined( memmove )
#if defined( HAVE_BMOVE ) || defined( bmove )
#define memmove(x,y,z)  bmove(y,x,z)
#else
#define memmove(x,y,z)  _bsd_memmove(x,y,z)
#ifndef _HAVE_BSD_MEMMOVE_PROTOTYPE
void *_bsd_memmove( void *dst0, const void *src0, register size_t length);
#endif
#endif
#endif

#if !defined( HAVE_STRCHR ) && !defined( strchr )
#if defined( HAVE_INDEX ) || defined( index )
#define strchr(x,y)  index(x,y)
#else
#define strchr(x,y)  _bsd_strchr(x,y)
char *_bsd_strchr( register const char *p, register int ch);
#endif
#endif

#if !defined( HAVE_STRRCHR ) && !defined( strrchr )
#if defined( HAVE_RINDEX ) || defined( rindex )
#define strrchr(x,y)  rindex(x,y)
#else
#define strrchr(x,y)  _bsd_strrchr(x,y)
char *_bsd_strrchr( register const char *p, register int ch);
#endif
#endif

#if !defined( HAVE_STRCASECMP ) && !defined( strcasecmp )
#define strcasecmp(x,y)  _bsd_strcasecmp( x, y)
int _bsd_strcasecmp( const char *s1, const char *s2);
#endif
#if !defined( HAVE_STRNCASECMP ) && !defined( strncasecmp )
#define strncasecmp(x,y,z)  _bsd_strncasecmp( x, y, z)
int _bsd_strncasecmp( const char *s1, const char *s2, register size_t n);
#endif

#if !defined( HAVE_STRSTR ) && !defined( strstr )
#define strstr(x,y)  _bsd_strstr( x, y)
char *_bsd_strstr( register const char *s, register const char *find);
#endif

#if !defined( HAVE_STRTOL ) && !defined( strtol )
#define strtol(x,y,z)  _bsd_strtol( x, y, z)
long _bsd_strtol( const char *nptr, char **endptr, register int base);
#endif

#if !defined( HAVE_STRDUP ) && !defined( strdup )
#define strdup(x)  _bsd_strdup( x )
char *_bsd_strdup( const char *str );
#endif

#if !defined( HAVE_STRERROR ) && !defined( strerror )
#define strerror(x)  (sys_errlist[x])
extern char *sys_errlist[];
#endif

#ifdef __cplusplus
}
#endif

#endif
