/*
    FLUIdS - local search system
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstdio.h" /* <stdio.h> */
#include "_pstring.h" /* <string.h> */
#include <stdlib.h>

#include "zcontext.h"
#include "zerror.h"
#include "zstdio.h"
#include "zfilter.h"

#define VERSION                   "2.3"

void printVersion( struct zcontext_t *cnt, void *info);
Boolean unix2dos( struct zcontext_t *cnt, FILE *fin, FILE *fout, void *info);

void main( int argc, char **argv)
{
  struct zcontext_t context;
  struct zhelpers_t helpers;
  int exitCode;

  zContextInit( &context, NULL, NULL, NULL, 0);
  zInitHelpers( &helpers, printVersion, NULL, NULL, NULL, NULL);

  exitCode = zFilter( &context, argc, argv, &helpers, unix2dos, NULL);

  zContextFree( &context );
  exit( exitCode );
}

#ifdef __MSVC__
#pragma warning( disable: 4100)
#else
#pragma warn -par
#endif

void printVersion( struct zcontext_t *cnt, void *info)
{
  zfprintf( cnt, stderr, "UNIX to DOS convertor v%s (%s) Freeware (f) VVK, CNII Center, Moscow\n",
    VERSION, __DATE__);
}

Boolean unix2dos( struct zcontext_t *cnt, FILE *fin, FILE *fout, void *info)
{
  Boolean wasnt0D = True, success = True;
  unsigned char inbuf[16*BUFSIZ], outbuf[2*16*BUFSIZ];
  int readCount, dest, src;

  while( (readCount = fread( inbuf, 1, sizeof(inbuf), fin)) > 0 )
  {
    for( dest = src = 0; src < readCount; src++)
    {
      register int c;
      if( (c = inbuf[src]) == 0x0a && wasnt0D )
	outbuf[ dest++ ] = 0x0d;
      outbuf[ dest++ ] = c;
      wasnt0D = (c != 0x0d) ? True : False;
    }

    if( dest > 0 && fwrite( outbuf, dest, 1, fout) != 1 )
    {
      if( !ferror( fout ) )
      {
        cnt->errorCode = zerFileWrite;
        cnt->errorPtr = "-Output-";
	success = False;
      }
      break;
    }

    if( readCount != sizeof(inbuf) ) break;
  }

  return success;
}

#ifdef __MSVC__
#pragma warning( default: 4100)
#else
#pragma warn .par
#endif
