/*
    FLUIdS - local search system
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstdio.h" /* <stdio.h> */
#include "_pstring.h" /* <string.h> */
#include <stdlib.h>

#include "zcontext.h"
#include "zerror.h"
#include "zstdio.h"
#include "zfilter.h"

#define VERSION                   "2.3"

void printVersion( struct zcontext_t *cnt, void *info);
Boolean dos2unix( struct zcontext_t *cnt, FILE *fin, FILE *fout, void *info);

void main( int argc, char **argv)
{
  struct zcontext_t context;
  struct zhelpers_t helpers;
  int exitCode;

  zContextInit( &context, NULL, NULL, NULL, 0);
  zInitHelpers( &helpers, printVersion, NULL, NULL, NULL, NULL);

  exitCode = zFilter( &context, argc, argv, &helpers, dos2unix, NULL);

  zContextFree( &context );
  exit( exitCode );
}

#ifdef __MSVC__
#pragma warning( disable: 4100)
#else
#pragma warn -par
#endif

void printVersion( struct zcontext_t *cnt, void *info)
{
  zfprintf( cnt, stderr, "DOS to UNIX convertor v%s (%s) Freeware (f) VVK, CNII Center, Moscow\n",
    VERSION, __DATE__);
}

Boolean dos2unix( struct zcontext_t *cnt, FILE *fin, FILE *fout, void *info)
{
  int shift = 0, dest, src, readCount;
  unsigned char buf[16*BUFSIZ];
  Boolean success = True;

  while( (readCount = fread( &buf[shift], 1, sizeof(buf) - shift, fin)) > 0 )
  {
    readCount += shift;
    for( dest = src = 0; src < readCount; src++)
    {
      register int c;
      if( (c = buf[src]) == 0x0d )
      {
	if( src == readCount-1 ) break;
	else if( buf[src+1] == 0x0a ) continue;
      }
      buf[ dest++ ] = c;
    }

    if( dest > 0 && fwrite( buf, dest, 1, fout) != 1 )
    {
      if( !ferror( fout ) )
      {
        cnt->errorCode = zerFileWrite;
        cnt->errorPtr = "-Output-";
	success = False;
      }
      break;
    }

    if( readCount != sizeof(buf) ) break;

    if( src == readCount-1 )
    {
      shift = 1;
      buf[0] = 0x0d;
    }
    else
      shift = 0;
  }

  return success;
}

#ifdef __MSVC__
#pragma warning( default: 4100)
#else
#pragma warn .par
#endif
