/*
    FLUIdS - local search system
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstdio.h" /* <stdio.h> */

#include "zcontext.h"
#include "zalloc.h"
#include "zerror.h"
#include "zfile.h"
#include "zstdlib.h"

#include "defs.h"
#include "error.h"
#include "wtrack.h"

#define WORD_TRACK_INIT               500
#define WORD_TRACK_DELTA              200

Boolean wtKeep( struct wordtrack_t *wt, const char *word, struct zfileobject_t *fo)
{
  int first = *((unsigned char *) word) - 32;
  unsigned zshort_t spot = wt->deltas[first+1], count = wt->deltas[224];
  zoff_t offset;

  if( wt->deltas[first] != spot &&
      wt->letters[spot-1] == ((unsigned char *) word)[1] )
    return True;

  if( count == 0 )
  {
    wt->reserved = WORD_TRACK_INIT;
    wt->letters = (unsigned char *) zMalloc( wt->context, wt->reserved);
    wt->offsets = (unsigned char *) zMalloc( wt->context, wt->reserved * 4);
  }
  else if( count == wt->reserved )
  {
    wt->reserved += WORD_TRACK_DELTA;
    wt->letters = (unsigned char *) zRealloc( wt->context, wt->letters, wt->reserved);
    wt->offsets = (unsigned char *) zRealloc( wt->context, wt->offsets, wt->reserved * 4);
  }
  wt->alloced = True;

  for( first++; first <= 224; first++) wt->deltas[first]++;

  wt->letters[spot] = ((unsigned char *) word)[1];
  if( (offset = zFileObjectTell( fo )) < 0 ) return False;

  zSetLong( &wt->offsets[4*spot], offset, INDEX_FILE_ENDIAN);

  return True;
}

Boolean wtWrite( struct wordtrack_t *wt, struct zfileobject_t *fo)
{
  unsigned zshort_t count = wt->deltas[224], i;
  unsigned char buf[225*2];

  for( i = 0; i <= 224; i++)
    zSetShort( &buf[2*i], wt->deltas[i], INDEX_FILE_ENDIAN);

  if( fwrite( buf, 225 * 2, 1, fo->stream) != 1 ||
      (count > 0 &&
       (fwrite( wt->letters, count, 1, fo->stream) != 1 ||
        fwrite( wt->offsets, count*4, 1, fo->stream) != 1)) )
  {
    wt->context->printError( wt->context, zerFileWrite, fo->alias);
    return False;
  }

  return True;
}
