/*
    FLUIdS - local search system
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstdio.h" /* <stdio.h> */
#include <stdlib.h>

#include "zcontext.h"
#include "zalloc.h"
#include "zerror.h"
#include "zfile.h"
#include "zstdlib.h"

#include "defs.h"
#include "error.h"
#include "wtrack.h"

zoff_t wtFollow( struct wordtrack_t *wt, const char *word, zoff_t *pstopOffset, Boolean forWordPattern)
{
  int first = *((unsigned char *) word) - 32, second = ((unsigned char *) word)[1];
  unsigned zshort_t lower = wt->deltas[first], upper = wt->deltas[first+1], midpoint;

  if( lower == upper )
  {
    if( pstopOffset != NULL ) *pstopOffset = 0;
    return 0;
  }

  if( forWordPattern && second == '\0' )
  {
    if( pstopOffset != NULL && first < (int) wt->deltas[224] - 1 )
      *pstopOffset = (zoff_t) zGetLong(
        (const unsigned char *) &wt->offsets[4*upper], INDEX_FILE_ENDIAN);
    return (zoff_t) zGetLong( &wt->offsets[4*lower], INDEX_FILE_ENDIAN);
  }

  for( --upper; lower <= upper; )
  {
    midpoint = (unsigned zshort_t) ((lower + upper) >> 1);

    if( wt->letters[midpoint] == second )
    {
      if( pstopOffset != NULL && midpoint < (unsigned zshort_t) (wt->deltas[224]-1) )
        *pstopOffset = (zoff_t) zGetLong( &wt->offsets[4*midpoint+4], INDEX_FILE_ENDIAN);
      return (zoff_t) zGetLong( &wt->offsets[4*midpoint], INDEX_FILE_ENDIAN);
    }
    else if( wt->letters[midpoint] < (unsigned char) second )
      lower = midpoint + 1;
    else if( midpoint == 0 )
      break;
    else
      upper = midpoint - 1;
  }

  if( pstopOffset != NULL ) *pstopOffset = 0;
  return 0;
}

Boolean wtRead( struct wordtrack_t *wt, struct zfileobject_t *fo)
{
  size_t count;
  unsigned char buf[225*2], *ptr;
  int i;

  /* 砫 ⠥ ᬥ饭;  225 ;   室  2  */
  if( zFileObjectRead( fo, buf, 2 * 225, False) == NULL ) return False;

  /* ८ࠧ㥬 祭 ᬥ饭  ⪮ 楫 */
  for( i = 0; i < 225; i++)
    wt->deltas[i] = zGetShort( &buf[2*i], INDEX_FILE_ENDIAN);

  /* 祭 ᬥ饭     뢠饬 浪;
     祭 ᫥ ᬥ饭, deltas[224], 砥 饥 ᫮ ⮢
     ४ ᫮ */
  for( i = 0; i < 224; i++)
    if( wt->deltas[i] > wt->deltas[i+1] )
    {
      wt->context->printError( wt->context, fo->errs[ZFILEOBJECT_ERRORCODE_INVALID_FORMAT], fo->alias);
      return False;
    }

  /* ᫨ ᫮ ⮢ ४ ᫮ - 㫥,   -   祬 */
  if( (count = wt->deltas[224]) == 0 )
  {
    wt->alloced = False;
    return True;
  }

  /* ᫨  ᯮ " 䠩",     㪢 室
     뤥  */
  if( !zCheckFlags( fo->flags, zfoMapped) )
  {
    wt->alloced = True;
    wt->letters = (unsigned char *) zMalloc( wt->context, count);
    wt->offsets = (unsigned char *) zMalloc( wt->context, 4*count);
  }

  /*  ⥭  䠩 ꥪ 室 ஦:
     zFileObjectRead   NULL!!! */
  if( (ptr = zFileObjectRead( fo, wt->letters, count, True)) == NULL ) return False;
  wt->letters = ptr;
  if( (ptr = zFileObjectRead( fo, wt->offsets, 4*count, True)) == NULL ) return False;
  wt->offsets = ptr;

  return True;
}
