/*
    FLUIdS - local search system
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef __WTRACK_A
#define __WTRACK_A

#ifndef __ZDEFS_A
#include "zdefs.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif

struct wordtrack_t
{
  struct zcontext_t *context;
  unsigned zshort_t deltas[225];
  unsigned zshort_t reserved;
  unsigned char *letters;
  unsigned char *offsets;
  Boolean alloced;
};

void wtInit( struct zcontext_t *cnt, struct wordtrack_t *wt);
void wtFree( struct wordtrack_t *wt );

zoff_t wtFollow( struct wordtrack_t *wt, const char *word, zoff_t *pstopOffset, Boolean forWordPattern);
Boolean wtRead( struct wordtrack_t *wt, struct zfileobject_t *fo);

Boolean wtKeep( struct wordtrack_t *wt, const char *word, struct zfileobject_t *fo);
Boolean wtWrite( struct wordtrack_t *wt, struct zfileobject_t *fo);

#ifdef __cplusplus
}
#endif

#endif
