/*
    FLUIdS - local search system
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstdio.h" /* <stdio.h> */
#include "_pstring.h" /* <string.h> */

#include "zcoll.h"
#include "zfile.h"

#include "defs.h"
#include "words.h"

Boolean readWordCollection( struct zstrcoll_t *words, struct zfileobject_t *fo,
    zint_t length, char *recodeTable)
{
  unsigned char buf[MAX_STRING_LENGTH+1], *ptr;
  int shift, start, end, toRead, c;
  char *s;

  if( length <= 1 ) return True;

  for( shift = 0; ; )
  {
    if( (toRead = (sizeof(buf)-1) - shift) > length ) toRead = (int) length;
    if( zFileObjectRead( fo, &buf[shift], toRead, False) == NULL ) return False;

    length -= toRead;
    buf[ toRead + shift ] = '\0';

    for( start = 0; ; )
    {
      for( end = start; (c = buf[end]) != '\0' && c != ' '; end++) continue;

      if( end < sizeof(buf)-1 || length <= 1 )
      {
        if( c == ' ' ) buf[end] = '\0';
        if( buf[start] != '\0' )
        {
          if( recodeTable != NULL )
            for( ptr = &buf[start]; *ptr != '\0'; ptr++)
              if( (*ptr & 0x80) != 0 ) *ptr = recodeTable[ (*ptr & 0x7f) ];
          if( (s = zStringCollectionFind( words, (char *) &buf[start])) != NULL )
            *s = WORD_PRESENT;
          else
            addCollectionWord( words, (char *) &buf[start], WORD_PRESENT);
        }
        if( c == '\0' ) return True;
      }
      else
        break;

      if( (start = end+1) >= sizeof(buf)-1 ) break;
    }

    if( length <= 0 ) return True;           /* XXX on any case */

    if( start < end && start != 0 )
    {
      shift = end - start;
      memmove( &buf[0], &buf[start], shift);
    }
  }
}
