/*
    FLUIdS - local search system
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstdio.h" /* <stdio.h> */
#include "_pstring.h" /* <string.h> */

#include "zcoll.h"

#include "words.h"

Boolean writeWordCollection( struct zstrcoll_t *words, FILE *stream, 
    char *convTable, unsigned int *pcount)
{
  Boolean first = True;
  unsigned int count;
  int cur;
  char *ptr;

  if( pcount != NULL ) *pcount = 0;
  count = 0;

  for( cur = 0; cur < words->count; cur++)
  {
    char *item = words->list[cur];
    if( *item != WORD_PRESENT ) continue;
    item++;

    if( convTable != NULL )
      for( ptr = item; *ptr != '\0'; ptr++)
        if( (*ptr & 0x80) != 0 ) *ptr = convTable[ (*ptr & 0x7f) ];
    if( *item == '\0' ) continue;

    if( (!first && fwrite( " ", 1, 1, stream) != 1) ||
        fwrite( item, strlen( item ), 1, stream) != 1 )
      return False;

    count++;
    first = False;
  }

  if( count > 0 && fwrite( "\0", 1, 1, stream) != 1 ) return False;
  if( pcount != NULL ) *pcount = count;

  return True;
}
