/*
    FLUIdS - local search system
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstring.h" /* <string.h> */

#include "zcontext.h"
#include "zcoll.h"

#include "fludata.h"
#include "words.h"

Boolean checkStopWord( struct zcontext_t *cnt, const char *word)
{
  char *s = zStringCollectionFind( FLU(cnt)->stopWords, word);

  if( s != NULL )
  {
    *s = WORD_PRESENT;
    return True;
  }

  return False;
}

Boolean checkValidWord( struct zcontext_t *cnt, const char *word)
{
  char *s = zStringCollectionFind( FLU(cnt)->validWords, word);

  if( s != NULL )
  {
    *s = WORD_PRESENT;
    return True;
  }

  return False;
}
