/*
    FLUIdS - local search system
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef __STOPWORD_A
#define __STOPWORD_A

#ifndef __ZDEFS_A
#include "zdefs.h"
#endif

#ifndef ___PSTDIO_A
#include "_pstdio.h"
#endif

#ifndef __ZCOLL_A
#include "zcoll.h"
#endif

#ifndef __FLUCNT_A
#include "fludata.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif

#define WORD_PRESENT                   '+'
#define WORD_ABSENT                    '-'

/* Word collections */
Boolean checkStopWord( struct zcontext_t *cnt, const char *word);
Boolean checkValidWord( struct zcontext_t *cnt, const char *word);

Boolean readWordCollection( struct zstrcoll_t *words, struct zfileobject_t *fo,
    zint_t length, char *recodeTable);
Boolean writeWordCollection( struct zstrcoll_t *words, FILE *stream,
    char *convTable, unsigned int *pcount);

#define addCollectionWord(x,w,b) \
    do                           \
    {                            \
      char type = (b);           \
      zParamCollectionAdd( (struct zparamcoll_t *) (x), (w), &type, 1); \
    } while( 0 )

/* Useful macros */
#define addStopWord(cnt,word,b) addCollectionWord( FLU(cnt)->stopWords, word, b)

#define isStopWord(cnt,word) \
    (zStringCollectionFind( FLU(cnt)->stopWords, word) != NULL)

#define freeStopWords(cnt) \
    zStringCollectionFree( FLU(cnt)->stopWords )

#define addValidWord(cnt,word,b) addCollectionWord( FLU(cnt)->validWords, word, b)

#define isValidWord(cnt,word) \
    (zStringCollectionFind( FLU(cnt)->validWords, word) != NULL)

#define freeValidWords(cnt)   \
    zStringCollectionFree( FLU(cnt)->validWords )

#ifdef __cplusplus
}
#endif

#endif
