/*
    FLUIdS - local search system
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef __STRUCTUR_A
#define __STRUCTUR_A

#ifndef __ZDEFS_A
#include "zdefs.h"
#endif

#ifndef __DEFS_A
#include "defs.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif

#define MAX_AREA_STRING_SIZE              5
#define MAX_STRUCTURE_STRING_SIZE         25

#define AREA_FLAG_KEYWORD                 ((_st_t) 0x0001u)
#define AREA_FLAG_CONTENT                 ((_st_t) 0x0002u)
#define AREA_FLAG_TITLE                   ((_st_t) 0x0004u)
#define AREA_FLAG_FILENAME                ((_st_t) 0x0008u)
#define AREA_FLAG_ANY                     ((_st_t) 0x000fu)

#define CHIC_CONTENT_NONE_CAPITAL         ((_st_t) 0x0010u)
#define CHIC_CONTENT_FIRST_CAPITAL        ((_st_t) 0x0020u)
#define CHIC_CONTENT_ALL_CAPITAL          ((_st_t) 0x0040u)
#define CHIC_CONTENT_LAST_CAPITAL         ((_st_t) 0x0080u)
#define CHIC_CONTENT_ANY_CAPITAL          ((_st_t) 0x00f0u)
#define CHIC_TITLE_NONE_CAPITAL           ((_st_t) 0x0100u)
#define CHIC_TITLE_FIRST_CAPITAL          ((_st_t) 0x0200u)
#define CHIC_TITLE_ALL_CAPITAL            ((_st_t) 0x0400u)
#define CHIC_TITLE_LAST_CAPITAL           ((_st_t) 0x0800u)
#define CHIC_TITLE_ANY_CAPITAL            ((_st_t) 0x0f00u)
#define CHIC_FILENAME_NONE_CAPITAL        ((_st_t) 0x1000u)
#define CHIC_FILENAME_FIRST_CAPITAL       ((_st_t) 0x2000u)
#define CHIC_FILENAME_ALL_CAPITAL         ((_st_t) 0x4000u)
#define CHIC_FILENAME_LAST_CAPITAL        ((_st_t) 0x8000u)
#define CHIC_FILENAME_ANY_CAPITAL         ((_st_t) 0xf000u)

#define CHIC_NONE_CAPITAL                 ((_st_t) 0x0010u)
#define CHIC_FIRST_CAPITAL                ((_st_t) 0x0020u)
#define CHIC_ALL_CAPITAL                  ((_st_t) 0x0040u)
#define CHIC_LAST_CAPITAL                 ((_st_t) 0x0080u)
#define CHIC_ANY_CAPITAL                  ((_st_t) 0x00f0u)

#define CHIC_CONTENT_SHIFT                0
#define CHIC_TITLE_SHIFT                  4
#define CHIC_FILENAME_SHIFT               8
#define CHIC_MASK                         ((_st_t) 0x00f0)
#define CHIC_UMASK                        ((_st_t) 0xff00)

#define AREA_CHAR_KEYWORD                 'k'
#define AREA_CHAR_CONTENT                 'c'
#define AREA_CHAR_TITLE                   't'
#define AREA_CHAR_FILENAME                'n'

#define CHIC_CHAR_NONE_CAPITAL            'n'
#define CHIC_CHAR_FIRST_CAPITAL           'f'
#define CHIC_CHAR_ALL_CAPITAL             'a'
#define CHIC_CHAR_LAST_CAPITAL            'm'

#define AREA_STRING_KEYWORD               "k"
#define AREA_STRING_CONTENT               "c"
#define AREA_STRING_TITLE                 "t"
#define AREA_STRING_FILENAME              "n"

_st_t getAreaValue( const char *string );
const char *getAreaString( char *string, _st_t structure);

_st_t getCharacteristicValue( char *word, Boolean isPattern);
const char *getStructureString( char *string, _st_t structure);

#define HAS_CHARACTERISTIC(st) \
    ((zCheckFlags( (st), AREA_FLAG_CONTENT) && zCheckFlags( (st), CHIC_CONTENT_ANY_CAPITAL)) || \
     (zCheckFlags( (st), AREA_FLAG_TITLE) && zCheckFlags( (st), CHIC_TITLE_ANY_CAPITAL)) || \
     (zCheckFlags( (st), AREA_FLAG_FILENAME) && zCheckFlags( (st), CHIC_FILENAME_ANY_CAPITAL)))

#define GET_AREA_COUNT(count,ar); \
    (count) = 0;                  \
    if( zCheckFlags( (ar), AREA_FLAG_CONTENT) ) (count)++; \
    if( zCheckFlags( (ar), AREA_FLAG_TITLE) ) (count)++; \
    if( zCheckFlags( (ar), AREA_FLAG_FILENAME) ) (count)++;

/* ⮢ ।⠢ -> 㡠⮢ */
#define EXTEND_STRUCTURE(st,ar); \
    if( zCheckFlags( (ar), AREA_FLAG_TITLE) ) zSetFlags( (st), ((st) & CHIC_MASK) << CHIC_TITLE_SHIFT); \
    if( zCheckFlags( (ar), AREA_FLAG_FILENAME) ) zSetFlags( (st), ((st) & CHIC_MASK) << CHIC_FILENAME_SHIFT); \
    if( !zCheckFlags( (ar), AREA_FLAG_CONTENT) ) zUnsetFlags( (st), CHIC_MASK);

/* 㡠⮢ ।⠢ -> ⮢ (᫨ ⠪ ) */
#define SHRINK_STRUCTURE(st); \
    if( zCheckFlags( (st), AREA_FLAG_TITLE) ) \
    {                         \
      zSetFlags( (st), ((st) >> CHIC_TITLE_SHIFT) & CHIC_MASK); \
      zUnsetFlagsEx( (st), CHIC_UMASK, _st_t); \
    }                         \
    else if( zCheckFlags( (st), AREA_FLAG_FILENAME) ) \
    {                         \
      zSetFlags( (st), ((st) >> CHIC_FILENAME_SHIFT) & CHIC_MASK); \
      zUnsetFlagsEx( (st), CHIC_UMASK, _st_t); \
    }

#define FIXUP_STRUCTURE(st) \
    if( !zCheckFlags( (st), AREA_FLAG_CONTENT) ) zSetFlags( (st), CHIC_CONTENT_ANY_CAPITAL)

#define UNFIXUP_STRUCTURE(st) \
    if( !zCheckFlags( (st), AREA_FLAG_CONTENT) ) zUnsetFlagsEx( (st), CHIC_CONTENT_ANY_CAPITAL, _st_t)

#ifdef __cplusplus
}
#endif

#endif
