/*
    FLUIdS - local search system
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"

#include "structur.h"

const char *getStructureString( char *string, _st_t structure)
{
  string[0] = '[';
  string[1] = (char) (zCheckFlags( structure, AREA_FLAG_CONTENT) ? AREA_CHAR_CONTENT : '-');
  string[2] = (char) (zCheckFlags( structure, AREA_FLAG_TITLE) ? AREA_CHAR_TITLE : '-');
  string[3] = (char) (zCheckFlags( structure, AREA_FLAG_FILENAME) ? AREA_CHAR_FILENAME : '-');
  string[4] = (char) (zCheckFlags( structure, AREA_FLAG_KEYWORD) ? AREA_CHAR_KEYWORD : '-');
  string[5] = ']';

  string[6] = '(';
  if( zCheckFlags( structure, AREA_FLAG_CONTENT) )
  {
    string[7] = (char) (zCheckFlags( structure, CHIC_CONTENT_NONE_CAPITAL) ? CHIC_CHAR_NONE_CAPITAL : '-');
    string[8] = (char) (zCheckFlags( structure, CHIC_CONTENT_FIRST_CAPITAL) ? CHIC_CHAR_FIRST_CAPITAL : '-');
    string[9] = (char) (zCheckFlags( structure, CHIC_CONTENT_ALL_CAPITAL) ? CHIC_CHAR_ALL_CAPITAL : '-');
    string[10] = (char) (zCheckFlags( structure, CHIC_CONTENT_LAST_CAPITAL) ? CHIC_CHAR_LAST_CAPITAL : '-');
  }
  else
    string[7] = string[8] = string[9] = string[10] = ' ';
  string[11] = ')';

  string[12] = '(';
  if( zCheckFlags( structure, AREA_FLAG_TITLE) )
  {
    string[13] = (char) (zCheckFlags( structure, CHIC_TITLE_NONE_CAPITAL) ? CHIC_CHAR_NONE_CAPITAL : '-');
    string[14] = (char) (zCheckFlags( structure, CHIC_TITLE_FIRST_CAPITAL) ? CHIC_CHAR_FIRST_CAPITAL : '-');
    string[15] = (char) (zCheckFlags( structure, CHIC_TITLE_ALL_CAPITAL) ? CHIC_CHAR_ALL_CAPITAL : '-');
    string[16] = (char) (zCheckFlags( structure, CHIC_TITLE_LAST_CAPITAL) ? CHIC_CHAR_LAST_CAPITAL : '-');
  }
  else
    string[13] = string[14] = string[15] = string[16] = ' ';
  string[17] = ')';

  string[18] = '(';
  if( zCheckFlags( structure, AREA_FLAG_FILENAME) )
  {
    string[19] = (char) (zCheckFlags( structure, CHIC_FILENAME_NONE_CAPITAL) ? CHIC_CHAR_NONE_CAPITAL : '-');
    string[20] = (char) (zCheckFlags( structure, CHIC_FILENAME_FIRST_CAPITAL) ? CHIC_CHAR_FIRST_CAPITAL : '-');
    string[21] = (char) (zCheckFlags( structure, CHIC_FILENAME_ALL_CAPITAL) ? CHIC_CHAR_ALL_CAPITAL : '-');
    string[22] = (char) (zCheckFlags( structure, CHIC_FILENAME_LAST_CAPITAL) ? CHIC_CHAR_LAST_CAPITAL : '-');
  }
  else
    string[19] = string[20] = string[21] = string[22] = ' ';
  string[23] = ')';

  string[24] = '\0';

  return string;
}
