/*
    FLUIdS - local search system
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "zchars.h"

#include "structur.h"

_st_t getCharacteristicValue( char *word, Boolean isPattern)
{
  register int c;
  register unsigned char *ptr = (unsigned char *) word;
  register _st_t characteristic;
  Boolean first, firstUp, lastUp, hasDown, hasPattern;

  first = True;
  hasDown = firstUp = lastUp = hasPattern = False;

  for( ; (c = *ptr) != '\0'; ptr++)
    if( (ztCharbitTable[c] & (CHAR_ENGLISH | CHAR_RUSSIAN)) != 0 )
    {
      if( first )
      {
	first = False;
	if( (ztCharbitTable[c] & (CHAR_ENGLISH_UP | CHAR_RUSSIAN_UP)) != 0 )
	{
	  firstUp = True;
	  *ptr = _toLower( c );
	}
	else
	  hasDown = True;
      }
      else
      {
	if( (ztCharbitTable[c] & (CHAR_ENGLISH_UP | CHAR_RUSSIAN_UP)) != 0 )
	{
	  lastUp = True;
          *ptr = _toLower( c );
        }
        else
          hasDown = True;
      }
    }
    else if( isPattern && (c == '*' || c == '?') )
      hasPattern = True;

  if( first )
    characteristic = 0;
  else if( !hasDown )
    characteristic = CHIC_ALL_CAPITAL;
  else if( lastUp )
    characteristic = CHIC_LAST_CAPITAL;
  else if( firstUp )
  {
    characteristic = CHIC_FIRST_CAPITAL;
    if( hasPattern ) zSetFlags( characteristic, CHIC_LAST_CAPITAL);
  }
  else
    characteristic = CHIC_NONE_CAPITAL;

  return characteristic;
}
