/*
    FLUIdS - local search system
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef __SEARCHER_A
#define __SEARCHER_A

#ifndef __ZDEFS_A
#include "zdefs.h"
#endif

#ifndef __ZTIME_A
#include "ztime.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif

struct expression_t;
struct indexfile_t;
struct flu_searcher_t;
struct flu_searcher_data_t;
struct flu_searcher_result_t;

typedef void (*flu_searcher_printerror_t)( struct flu_searcher_t *, unsigned zint_t, const char *);
typedef void (*flu_searcher_memfail_t)( struct flu_searcher_t *, const char *);
typedef Boolean (*flu_searcher_printresult_t)( struct flu_searcher_t *, struct flu_searcher_result_t *);

struct flu_searcher_indexfile_t
{
/* Index file */
  struct indexfile_t *pif;
  Boolean isOpen;
  Boolean wasOpen;
  Boolean wasError;

/* Other */
  int number;
  void *info;
  int foundCount;
};

struct flu_searcher_t
{
  struct zcontext_t *context;
  unsigned zint_t errorCode;
  int allocCount;

/* User info */
  flu_searcher_printerror_t printError;
  flu_searcher_memfail_t memoryFail;
  unsigned int searchArea;
  unsigned int searchFlags;
  int startNumber;
  int resultCount;
  void *info;
  int step;
  const char *query;

/* Index list */
  struct flu_searcher_indexfile_t *indexes;
  int indexCount;

/* Search data */
  struct expression_t *q;
  struct ztimeval_t *startTime;
  struct ztimeval_t *endTime;
  int foundCount;
  int printCount;
  float maxRank;

/* Main pointer */
  struct flu_searcher_data_t *ptr;
};

struct flu_searcher_result_t
{
/* External data */
  Boolean wasError;
  int number;
  struct flu_searcher_indexfile_t *indexFile;

/* Internal data */
  int rank;
  char *url;
  char *title;
  char *content;
  int urlLength;
  int titleLength;
  int contentLength;
  zoff_t size;
  ztime_t lastModified;
  Boolean allContent;
};

#define FLU_SEARCHER_FLAG_HAVE_RESULT_WINDOW     0x0001u
#define FLU_SEARCHER_FLAG_MEMORY_FAIL            0x0100u

enum
{
  fssStepDone,
  fssStepInit,
  fssStepCompile,
  fssStepSearch,
  fssStepPrinting
};

ZAPI(Boolean) fluSearcherInit( struct flu_searcher_t *fs,
    flu_searcher_printerror_t printError, flu_searcher_memfail_t memoryFail,
    void *info);
ZAPI(void) fluSearcherFree( struct flu_searcher_t *fs );
ZAPI(const char *) fluSearcherErrorString( struct flu_searcher_t *fs,
    unsigned zint_t errorCode, const char *name);

#define FS_AREA_KEYWORD                0x0001u
#define FS_AREA_CONTENT                0x0002u
#define FS_AREA_TITLE                  0x0004u
#define FS_AREA_FILENAME               0x0008u
#define FS_AREA_ANY                    0x000fu

#define fsfCaseDepend                  0x0001u
#define fsfStopOnError                 0x0002u
#define fsfShortForm                   0x0004u
#define fsfFoundCount                  0x0008u
#define fsfExtended                    0x0010u
/* XXX:  饥! */
#define fsfDateSorted                  0x0100u
#define fsfSizeSorted                  0x0200u
#define fsfUnsorted                    0x0400u
#define fsfDowngradeSorting            0x0800u

ZAPI(Boolean) fluSearcherSetParams( struct flu_searcher_t *fs,
    unsigned int searchArea, unsigned int searchFlags,
    int startNumber, int resultCount);
ZAPI(Boolean) fluSearcherSetQuery( struct flu_searcher_t *fs, const char *query);

ZAPI(Boolean) fluSearcherMakeSearch( struct flu_searcher_t *fs, int count,
    const char **indexes, const char **aliases, void **infos);

ZAPI(Boolean) fluSearcherPrintResults( struct flu_searcher_t *fs,
    flu_searcher_printresult_t printResult, unsigned int flags);
ZAPI(Boolean) fluSearcherInitResult( struct flu_searcher_t *fs, unsigned int flags);
ZAPI(struct flu_searcher_result_t *) fluSearcherNextResult( struct flu_searcher_t *fs );

#ifdef __cplusplus
}
#endif

#endif
