/*
    FLUIdS - local search system
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "zstdio.h"

#include "query.h"

void printExpression( struct zcontext_t *cnt, const struct expression_t *ex)
{
  int i;

  for( ; ex != NULL; ex = ex->next)
  {
    Boolean brackets = (Boolean) (ex->linkOperation == optExpression ||
      (ex->conditions.words.count > 1 &&
      !(ex->operation == optDummy && ex->next == NULL)));

    if( ex->operation == optAnd )
      zprintf( cnt, "and ");
    else if( ex->operation == optOr )
      zprintf( cnt, "or ");

    if( ex->reverse ) zprintf( cnt, "not ");

    if( brackets ) zprintf( cnt, "( ");

    if( ex->linkOperation == optExpression )
      printExpression( cnt, ex->conditions.value);
    else
      for( i = 0; i < ex->conditions.words.count; i++)
      {
        if( i > 0 )
        {
          if( ex->linkOperation == optOr )
            zprintf( cnt, "or ");
          else if( ex->linkOperation == optAnd )
            zprintf( cnt, "and ");
        }
        zprintf( cnt, "\"%s\" ", ex->conditions.words.list[i]);
      }

    if( brackets ) zprintf( cnt, ") ");
  }
}
