/*
    FLUIdS - local search system
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstring.h" /* <string.h> */

#include "zcontext.h"
#include "zalloc.h"
#include "zchars.h"

#include "cfg.h"
#include "defs.h"
#include "error.h"
#include "fludata.h"
#include "words.h"
#include "query.h"

static void addErrorWord( struct zcontext_t *cnt, const char *word, int errorCode)
{
  struct errword_t *ew, *lastew;

  for( lastew = NULL, ew = FLU(cnt)->errwordHead; ew != NULL; lastew = ew, ew = ew->next)
    if( ew->errorCode == errorCode &&
	(ew->word == word || strcmp( ew->word, word) == 0) ) break;
  if( ew != NULL ) return;

  ew = ZNEW( cnt, struct errword_t);
  ew->word = word;
  ew->errorCode = errorCode;
  ew->next = NULL;

  if( lastew == NULL )
    FLU(cnt)->errwordHead = ew;
  else
    lastew->next = ew;
}

void freeErrorWords( struct zcontext_t *cnt )
{
  struct errword_t *ew = FLU(cnt)->errwordHead;

  while( ew != NULL )
  {
    struct errword_t *tempew = ew;
    ew = ew->next;
    zFree( cnt, tempew);
  }

  FLU(cnt)->errwordHead = NULL;
}

Boolean checkQueryWords( struct zcontext_t *cnt, const struct expression_t *ex)
{
  Boolean success = True;
  int i;

  for( ; ex != NULL; ex = ex->next)
    if( ex->linkOperation == optExpression )
    {
      if( !checkQueryWords( cnt, ex->conditions.value) ) success = False;
    }
    else
      for( i = 0; i < ex->conditions.words.count; i++)
      {
        char *word = ex->conditions.words.list[i];
        int length;

        if( isStopWord( cnt, word) )
        {
          addErrorWord( cnt, word, errStopWord);
          success = False;
        }
        if( isValidWord( cnt, word) ) continue;

        if( (length = strlen( word )) < MIN_WORD_LENGTH &&
            (length == 0 || strchr( word+1, '*') == NULL) )
        {
          addErrorWord( cnt, word, errShortWord);
          success = False;
        }
        if( length > MAX_WORD_LENGTH )
        {
          addErrorWord( cnt, word, errLongWord);
          success = False;
        }

#ifdef BEGIN_WORD_CHAR_BITS
        if( !testChar( word[0], BEGIN_WORD_CHAR_BITS) )
        {
          addErrorWord( cnt, word, errBeginChar);
	  success = False;
	}
#endif
#ifdef END_WORD_CHAR_BITS
	if( !testChar( word[length-1], END_WORD_CHAR_BITS) )
	{
          addErrorWord( cnt, word, errEndChar);
	  success = False;
	}
#endif
      }

  return success;
}
