/*
    FLUIdS - local search system
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef __QUERY_A
#define __QUERY_A

#ifndef __ZDEFS_A
#include "zdefs.h"
#endif

#ifndef __DEFS_A
#include "defs.h"
#endif

#ifndef __CFG_A
#include "cfg.h"
#endif

#ifndef __ZCOLL_A
#include "zcoll.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif

#define PARSER_VERSION    "3.11"
#define RESULT_BLOCK_SIZE 199

struct result_t
{
  struct result_t *next;
  _fn_t filenum;
  float rank;
};

struct resultblock_t
{
  struct resultblock_t *next;
  int count;
  struct result_t results[RESULT_BLOCK_SIZE];
};

/* Result memory heap */
#define _resultMemoryHeap(cnt) ((cnt)->heap1)
#define resultMemoryHeap(cnt)  ((struct result_t *) _resultMemoryHeap(cnt))

#define _resultBlockHeap(cnt)  ((cnt)->heap2)
#define resultBlockHeap(cnt)   ((struct resultblock_t *) _resultBlockHeap(cnt))

#define newResultMemory(cnt,x);                  \
    if( _resultMemoryHeap(cnt) == NULL )         \
    {                                            \
      register struct resultblock_t *_rb = resultBlockHeap(cnt); \
      if( _rb != NULL && _rb->count < RESULT_BLOCK_SIZE ) \
        (x) = &_rb->results[_rb->count++];       \
      else                                       \
      {                                          \
        _rb = ZNEW( (cnt), struct resultblock_t); \
        _rb->next = resultBlockHeap(cnt);        \
        _rb->count = 1;                          \
        _resultBlockHeap(cnt) = _rb;             \
        (x) = &_rb->results[0];                  \
      }                                          \
    }                                            \
    else                                         \
    {                                            \
      (x) = resultMemoryHeap(cnt);               \
      _resultMemoryHeap(cnt) = resultMemoryHeap(cnt)->next; \
    }

#define freeResultMemory(cnt,x)                  \
    (x)->next = resultMemoryHeap(cnt);           \
    _resultMemoryHeap(cnt) = (x)

#define freeResultMemoryChain(cnt,x);            \
    if( (x) != NULL )                            \
    {                                            \
      register struct result_t *_r = (x);        \
      while( _r->next != NULL ) _r = _r->next;   \
      _r->next = resultMemoryHeap(cnt);          \
      _resultMemoryHeap(cnt) = (x);              \
    }

#define freeResultMemoryChainEx(cnt,x)           \
    if( (x) != NULL )                            \
    {                                            \
      register struct result_t *_r = (x);        \
      while( _r->next != NULL ) _r = _r->next;   \
      _r->next = resultMemoryHeap(cnt);          \
      _resultMemoryHeap(cnt) = (x);              \
      (x) = NULL;                                \
    }

#define freeResultMemoryHeap(cnt)                \
    do                                           \
    {                                            \
      while( _resultBlockHeap(cnt) != NULL )     \
      {                                          \
        register struct resultblock_t *_rb = resultBlockHeap(cnt); \
        _resultBlockHeap(cnt) = _rb->next;       \
        zFree( (cnt), _rb);                      \
      }                                          \
      _resultMemoryHeap(cnt) = NULL;             \
    } while( 0 )

/* Query */
struct expression_t
{
  int operation;
  Boolean reverse;
  struct expression_t *next;
  int linkOperation;
  union
  {
    struct expression_t *value;
    struct zstrcoll_t words;
  } conditions;
};

enum
{
  optDummy,
  optOr,
  optAnd,
  optExpression,
  optLast
};

#define msfCaseDepend                   0x0001u
#define msfUnsorted                     0x0002u

struct indexfile_t;

void freeExpression( struct zcontext_t *cnt, struct expression_t *ex);
struct expression_t *compileQuery( struct zcontext_t *cnt, const char *query);
struct result_t *makeSearch( struct indexfile_t *pif,
    const struct expression_t *expressions, _st_t area, unsigned int flags);

void printExpression( struct zcontext_t *cnt, const struct expression_t *ex);
void printQueryError( struct zcontext_t *cnt, const char *word);

/* Check query words */
struct errword_t
{
  const char *word;
  int errorCode;
  struct errword_t *next;
};

Boolean checkQueryWords( struct zcontext_t *cnt, const struct expression_t *ex);
void freeErrorWords( struct zcontext_t *cnt );

#ifdef __cplusplus
}
#endif

#endif
