/*
    FLUIdS - local search system
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef __INDXWORD_A
#define __INDXWORD_A

#ifndef __ZDEFS_A
#include "zdefs.h"
#endif

#ifndef __DEFS_A
#include "defs.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif

struct wordentry_t;

struct iw_location_t
{
  struct iw_location_t *next;
  int frequency;
  int emphasized;
  _fn_t filenum;
  _st_t structure;
};

struct iw_indexword_t
{
  const char *word;
  struct iw_location_t *list;
  struct iw_location_t *last;
};

struct iw_wordlist_t
{
  int count;
  int reserved;
  struct iw_indexword_t *list;
};

#define WORD_LIST_SIZE                 (256-32)

void iwInitWordList( struct iw_wordlist_t *wordList );
void iwFreeWordList( struct zcontext_t *cnt, struct iw_wordlist_t *wordList);

zint_t iwAddWord( struct zcontext_t *cnt, struct iw_wordlist_t *wordList,
    const char *word, _fn_t fnum, int emphasized, _st_t structure);

typedef unsigned zint_t (*iw_wordcount_t)( void *, _fn_t);

Boolean iwWriteWordList( struct zcontext_t *cnt, struct iw_wordlist_t *wordList,
    struct ztempfile_t *inSwap, struct ztempfile_t *outSwap,
    struct wordentry_t *we1, struct wordentry_t *we2,
    iw_wordcount_t getWordCount, void *info);

#ifdef __cplusplus
}
#endif

#endif
