/*
    FLUIdS - local search system
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstdio.h" /* <stdio.h> */
#include "_pstring.h" /* <string.h> */

#include "zcontext.h"
#include "zalloc.h"
#include "zerror.h"
#include "zfile.h"

#include "error.h"
#include "indxio.h"

Boolean fluEntryRead( struct flu_entry_t *entry, struct zfileobject_t *fo,
    FILE *input, unsigned int length, unsigned int flags)
{
  Boolean mapped = (Boolean) (fo != NULL && zCheckFlags( fo->flags, zfoMapped));
  FILE *stream = (fo != NULL) ? fo->stream : input;
  unsigned int entryLength;

/*  㦭 ᥣ ᫥, ⮡  뫮 ᬥ襭   
   ⮩   entry ⥭  fo  stream, ..  ࢮ 砥   
   㦤 ஢ ,   ஬ -  室 */
  ZCHECK_ALGR( entry->context, ((mapped && !entry->alloced) ||
    (!mapped && (entry->alloced || entry->buffer == NULL))), return False);

/* ।   */
  if( zCheckFlags( flags, ferEncodedLength) )
  {
#if defined( USE_MMAP ) && defined( HAVE_MMAP )
    if( fo != NULL && zCheckFlags( fo->flags, zfoMapped) )
    {
      unsigned char tmp;
      FLU_NUMBER_DECODE( entryLength, fo->addr, fo->offset);
    }
    else
#endif
    {
#undef FLU_UNSUCCESS_ACTION
#define FLU_UNSUCCESS_ACTION           goto read_error
      FLU_NUMBER_READ( entryLength, stream);
    }
  }
  else
    entryLength = length;
  entry->length = entryLength;

/* ࠢ  쭮    */
  if( zCheckFlags( flags, ferMinLength) && entryLength < length )
  {
format_error:
    entry->context->printError( entry->context,
      (fo == NULL) ? zerTempFileFormat : errIndexFileFormat,
      (fo == NULL) ? NULL : fo->alias);
    return False;
  }

/* ஢ਬ,  뫥    祭 । */
  if( entry->stopOffset > 0 )
  {
    zoff_t offset;
    if( fo != NULL )
      offset = zFileObjectTell( fo );
    else if( (offset = ftell( stream )) < 0 )
    {
      entry->context->printError( entry->context, zerTempFileTell, NULL);
      return False;
    }
    if( offset + (zoff_t) entryLength > entry->stopOffset ) goto format_error;
  }

/* ᫨  뢠    ⮡ࠦ 䠩,   
       4 㫥 ⮯- */
  if( !mapped )
  {
    entryLength += 4;
    FLU_ENTRY_RESIZE( entry, entryLength);
  }

/* ⠥ ᠬ  */
  if( fo != NULL )
  {
    unsigned char *buffer = zFileObjectRead( fo, entry->buffer, entry->length, True);
    if( buffer == NULL ) return False; else entry->buffer = buffer;
  }
  else
    if( fread( entry->buffer, entry->length, 1, stream) != 1 )
    {
read_error:
      entry->context->printError( entry->context,
        (fo == NULL) ? zerTempFileRead : errIndexFileRead,
        (fo == NULL) ? NULL : fo->alias);
      return False;
    }

/*  4  ⮯- */
  if( !mapped )
    entry->buffer[entry->length] = entry->buffer[entry->length+1] =
      entry->buffer[entry->length+2] = entry->buffer[entry->length+3] = '\0';

  return True;
}
