/*
    FLUIdS - local search system
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef __INDXIO_H
#define __INDXIO_H

#ifndef __ZDEFS_A
#include "zdefs.h"
#endif

#ifndef ___PSTDIO_A
#include "_pstdio.h"
#endif

#ifndef __STRUCTUR_A
#include "structur.h"
#endif

/***************************************************************************/
/*                                                                         */
/*  FLUIdS entry                                                           */
/*                                                                         */
/***************************************************************************/

#if SIZEOF_INT < 4
#define FLU_ENTRY_BUFFER_STEP          512
#else
#define FLU_ENTRY_BUFFER_STEP          (8*1024)
#endif
#define FLU_ENTRY_BUFFER_SIZE          (2*FLU_ENTRY_BUFFER_STEP)

struct flu_entry_t
{
  struct zcontext_t *context;
  unsigned char *buffer;
  unsigned int size;
  unsigned int length;
  Boolean alloced;
  zoff_t stopOffset;
};

#define FLU_ENTRY_INIT(cn,fe);         \
    (fe)->context = (cn);              \
    (fe)->buffer = NULL;               \
    (fe)->size = (fe)->length = 0;     \
    (fe)->alloced = False;             \
    (fe)->stopOffset = 0;

#define FLU_ENTRY_RESET(fe);           \
    (fe)->length = 0;

#define FLU_ENTRY_RESIZE(fe,ns);       \
    if( (fe)->size == 0 )              \
    {                                  \
      if( ((fe)->size = (ns)) <= FLU_ENTRY_BUFFER_SIZE ) \
        (fe)->size = FLU_ENTRY_BUFFER_SIZE; \
      else if( ((fe)->size % FLU_ENTRY_BUFFER_STEP) != 0 ) \
        (fe)->size = (((fe)->size / FLU_ENTRY_BUFFER_STEP) + 1) * FLU_ENTRY_BUFFER_STEP; \
      (fe)->buffer = (unsigned char *) zMalloc( (fe)->context, (fe)->size); \
    }                                  \
    else if( (ns) > (fe)->size )       \
    {                                  \
      (fe)->size = (ns);               \
      if( ((fe)->size % FLU_ENTRY_BUFFER_STEP) != 0 ) \
        (fe)->size = (((fe)->size / FLU_ENTRY_BUFFER_STEP) + 1) * FLU_ENTRY_BUFFER_STEP; \
      (fe)->buffer = (unsigned char *) zRealloc( (fe)->context, (fe)->buffer, (fe)->size); \
    }                                  \
    (fe)->alloced = True;

#define FLU_ENTRY_FREE(fe);            \
    if( (fe)->alloced && (fe)->buffer != NULL ) zFree( (fe)->context, (fe)->buffer); \
    (fe)->buffer = NULL;               \
    (fe)->size = 0;                    \
    (fe)->alloced = False;             \
    (fe)->stopOffset = 0;

#define FLU_ENTRY_ADD_BYTE(fe,b);      \
    {                                  \
      FLU_ENTRY_RESIZE( (fe), (fe)->length + 1); \
      (fe)->buffer[(fe)->length++] = (b); \
    }

#define FLU_ENTRY_ADD_DATA(fe,d,l);    \
    {                                  \
      unsigned int i, _len = (l);      \
      FLU_ENTRY_RESIZE( (fe), (fe)->length + _len); \
      for( i = 0; i < _len; i++) (fe)->buffer[(fe)->length++] = (d)[i]; \
    }

#define FLU_ENTRY_ADD_NUMBER(fe,n);    \
    {                                  \
      unsigned zint_t _num = (n);      \
      unsigned char _buf[16];          \
      unsigned int _len = 0;           \
      FLU_NUMBER_ENCODE( _num, _buf, _len); \
      FLU_ENTRY_RESIZE( (fe), (fe)->length + _len); \
      while( _len > 0 ) (fe)->buffer[(fe)->length++] = _buf[--_len]; \
    }

#define ferEncodedLength               0x0001u
#define ferMinLength                   0x0002u

struct flu_entry_t;
struct zfileobject_t;
Boolean fluEntryRead( struct flu_entry_t *entry, struct zfileobject_t *fo,
    FILE *stream, unsigned int length, unsigned int flags);

/***************************************************************************/
/*                                                                         */
/*  Encoding & decoding                                                    */
/*                                                                         */
/***************************************************************************/

#define FLU_NUMBER_ENCODE(num,buf,len); \
    (buf)[(len)++] = (num) & 0x7f;     \
    for( ;; )                          \
    {                                  \
      (num) >>= 7;                     \
      if( (num) == 0 ) break;          \
      (num)--;                         \
      (buf)[(len)++] = ((num) & 0x7f) | 0x80; \
    }

#define _FLU_NUMBER_DECODE(num,buf,len,x); \
    (x) = (buf)[(len)++];              \
    (num) = ((x) & 0x7f);              \
    if( ((x) & 0x80) != 0 )            \
      do                               \
      {                                \
        (num)++;                       \
        (num) <<= 7;                   \
        (x) = (buf)[(len)++];          \
        (num) |= ((x) & 0x7f);         \
      }while( ((x) & 0x80) != 0 );

#define FLU_NUMBER_DECODE(num,buf,len); \
    {                                  \
      unsigned char _tmp;              \
      _FLU_NUMBER_DECODE( (num), (buf), (len), _tmp); \
    }

#define FLU_NUMBER_SKIP(buf,len);      \
    if( ((buf)[(len)] & 0x80) != 0 )   \
      do{ (len)++; }while( ((buf)[(len)] & 0x80) != 0 ); \
    (len)++;

#define FLU_NUMBER_LENGTH(n,l);        \
    {                                  \
      unsigned zint_t _num = (n);      \
      (l) = 1;                         \
      _num >>= 7;                      \
      while( _num > 0 ){ _num--; _num >>= 7; (l)++; } \
    }

#define FLU_NUMBER_LENGTH_ADD(n,l);    \
    {                                  \
      unsigned zint_t _num = (n);      \
      (l)++;                           \
      _num >>= 7;                      \
      while( _num > 0 ){ _num--; _num >>= 7; (l)++; } \
    }

#define FLU_STRUCTURE_ENCODE(st,buf,len); \
    if( HAS_CHARACTERISTIC( st ) )     \
    {                                  \
      int count;                       \
      GET_AREA_COUNT( count, (st));    \
      if( count <= 1 )                 \
      {                                \
        SHRINK_STRUCTURE(st);          \
        (buf)[(len)++] = (unsigned char) (st); \
      }                                \
      else                             \
      {                                \
        FIXUP_STRUCTURE( st );         \
        (buf)[(len)++] = (unsigned char) ((st) >> 8); \
        (buf)[(len)++] = (unsigned char) (st); \
      }                                \
    }                                  \
    else                               \
    {                                  \
      zUnsetFlagsEx( (st), CHIC_MASK, _st_t); \
      (buf)[(len)++] = (unsigned char) (st); \
    }

#define FLU_STRUCTURE_DECODE(st,buf,len); \
    (st) = (buf)[(len)++];             \
    if( zCheckFlags( (st), CHIC_MASK) )\
    {                                  \
      int count;                       \
      GET_AREA_COUNT( count, (st));    \
      if( count > 1 )                  \
      {                                \
        zSetFlags( (st), (_st_t) ((buf)[(len)++] << 8)); \
        UNFIXUP_STRUCTURE( st );       \
      }                                \
      else                             \
      {                                \
        EXTEND_STRUCTURE((st),(st));   \
      }                                \
    }                                  \
    else                               \
    {                                  \
      EXTEND_STRUCTURE((st),(st));     \
    }

#define FLU_STRUCTURE_SKIP(buf,len);   \
    {                                  \
      _st_t st = (buf)[(len)];         \
      if( zCheckFlags( (st), CHIC_MASK) ) \
      {                                \
        int count;                     \
        GET_AREA_COUNT( count, st);    \
        if( count > 1 ) (len)++;       \
      }                                \
    }                                  \
    (len)++;

/***************************************************************************/
/*                                                                         */
/*  Reading & writing                                                      */
/*                                                                         */
/***************************************************************************/

/* #define FLU_UNSUCCESS_ACTION           return False */

#define _FLU_NUMBER_READ(num,stream,x); \
    (num) = 0;                         \
    do                                 \
    {                                  \
      if( fread( &(x), 1, 1, (stream)) != 1 ){ FLU_UNSUCCESS_ACTION; } \
      (num) <<= 7;                     \
      (num) += ((x) & 0x7f);           \
    }while( ((x) & 0x80) != 0 );

#define FLU_NUMBER_READ(num,stream);   \
    {                                  \
      unsigned char x;                 \
      _FLU_NUMBER_READ(num,stream,x);  \
    }

#define _FLU_NUMBER_WRITE(num,stream,buf,len); \
    (len) = 0;                         \
    FLU_NUMBER_ENCODE(num,buf,len);    \
    while( (len) > 0 )                 \
      if( fwrite( &(buf)[--(len)], 1, 1, (stream)) != 1 ){ FLU_UNSUCCESS_ACTION; }

#define FLU_NUMBER_WRITE(num,stream);  \
    {                                  \
      unsigned char buf[16];           \
      int len;                         \
      _FLU_NUMBER_WRITE(num,stream,buf,len); \
    }

/***************************************************************************/
/*                                                                         */
/*  Index items                                                            */
/*                                                                         */
/***************************************************************************/

#define FLU_PUT_RBUFFER(fe,buf,len);   \
    FLU_ENTRY_RESIZE( (fe), (len) + (fe)->length); \
    while( (len) > 0 ) (fe)->buffer[(fe)->length++] = (buf)[--(len)];

#define _FLU_ITEM_ADD(we,st,fn,rn,buf,len); \
    (len) = 0;                         \
    FLU_NUMBER_ENCODE((rn),(buf),(len)); \
    FLU_NUMBER_ENCODE((fn),(buf),(len)); \
    FLU_STRUCTURE_ENCODE((st),(buf),(len)); \
    FLU_PUT_RBUFFER((we),(buf),(len));

#define FLU_ITEM_ADD(fe,st,fn,rn);     \
    {                                  \
      unsigned char buf[32];           \
      int len;                         \
      _FLU_ITEM_ADD(fe,st,fn,rn,buf,len); \
    }

#endif
