/*
    FLUIdS - local search system
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef __INDXFILE_A
#define __INDXFILE_A

#ifndef __ZDEFS_A
#include "zdefs.h"
#endif

#ifndef __ZFILE_A
#include "zfile.h"
#endif

#ifndef __ZTIME_A
#include "ztime.h"
#endif

#ifndef __CFG_A
#include "cfg.h"
#endif

#ifndef __DEFS_A
#include "defs.h"
#endif

#ifndef __INDIO_A
#include "indio.h"
#endif

#ifndef __WTRACK_A
#include "wtrack.h"
#endif

#if defined( FLUIDS43 )
#ifndef __INDXDIR_A
#include "indxdir.h"
#endif

#ifndef __INDXIO_A
#include "indxio.h"
#endif
#endif

#ifdef __cplusplus
extern "C" {
#endif

extern const unsigned zint_t ifErrorCodes[];

#define INDEX_HEADER_SIZE           32
#define INDEX_HEADER_RESERVED       8
#define INDEX_CHECKSUM_LENGTH       (INDEX_HEADER_SIZE - INDEX_HEADER_RESERVED)
#define INDEX_OFFSET_COUNT          32

struct fileattrib_t
{
  zoff_t size;
  ztime_t lastModified;
};

struct indexheader_t
{
  unsigned char id[4];
  unsigned char version;
  unsigned char subversion;
  unsigned char checksum;
  unsigned char charset;
  unsigned zint_t wordCount;
  unsigned zint_t fileCount;
  zoff_t fileSize;
  ztime_t timeStamp;
  /* unsigned char reserved[INDEX_HEADER_RESERVED]; */
};

struct indexfile_t
{
  struct zcontext_t *context;
  const char *name;
  const char *alias;
  unsigned int flags;
  struct zfileobject_t *file;
  struct zfileobject_t fileObject;
  struct indexheader_t header;
  zoff_t offsets[INDEX_OFFSET_COUNT];
  struct wordtrack_t wordTrack;
#if defined( FLUIDS43 )
  struct idir_rlist_t dirList;
  struct flu_entry_t dirEntry;
#endif
  struct wordentry_t wordEntry;
  unsigned int stopWords;

#if defined( RUSSIAN_SUPPORT ) && defined( RUSSIAN_RELEASE )
  int charset;
  char *recodeTable;
  char *convTable;
#endif

  unsigned char *fileOffsets;
  unsigned char *fileStructures;

  const char *indexName;
  const char *indexDescription;
  const char *indexPointer;
  const char *indexAdmin;
  Boolean infoAlloced;
};

enum
{
  SECTION_INFO = 0,
#if defined( FLUIDS43 )
  SECTION_DIRS,
#endif
  SECTION_WORDS,
  SECTION_WORDTRACK,
  SECTION_STOPWORDS,
  SECTION_VALIDWORDS,
  SECTION_FILES,
  SECTION_FILEOFFSETS,
  SECTION_FILESTRUCTURES,
  SECTION_LAST
};

#define OFFSET_INFO_START           (SECTION_INFO * 2)
#define OFFSET_INFO_END             (SECTION_INFO * 2 + 1)
#if defined( FLUIDS43 )
#define OFFSET_DIRS_START           (SECTION_DIRS * 2)
#define OFFSET_DIRS_END             (SECTION_DIRS * 2 + 1)
#endif
#define OFFSET_WORDS_START          (SECTION_WORDS * 2)
#define OFFSET_WORDS_END            (SECTION_WORDS * 2 + 1)
#define OFFSET_WORDTRACK_START      (SECTION_WORDTRACK * 2)
#define OFFSET_WORDTRACK_END        (SECTION_WORDTRACK * 2 + 1)
#define OFFSET_STOPWORDS_START      (SECTION_STOPWORDS * 2)
#define OFFSET_STOPWORDS_END        (SECTION_STOPWORDS * 2 + 1)
#define OFFSET_VALIDWORDS_START     (SECTION_VALIDWORDS * 2)
#define OFFSET_VALIDWORDS_END       (SECTION_VALIDWORDS * 2 + 1)
#define OFFSET_FILES_START          (SECTION_FILES * 2)
#define OFFSET_FILES_END            (SECTION_FILES * 2 + 1)
#define OFFSET_FILEOFFSETS_START    (SECTION_FILEOFFSETS * 2)
#define OFFSET_FILEOFFSETS_END      (SECTION_FILEOFFSETS * 2 + 1)
#define OFFSET_FILESTRUCTURES_START (SECTION_FILESTRUCTURES * 2)
#define OFFSET_FILESTRUCTURES_END   (SECTION_FILESTRUCTURES * 2 + 1)
#define OFFSET_LAST                 (SECTION_LAST * 2)

#define MIN_OFFSET_VALUE (INDEX_HEADER_SIZE + INDEX_OFFSET_COUNT * 4)
#define MIN_WORDTRACK_SIZE (225 * 2)
#define MIN_INDEX_SIZE (MIN_OFFSET_VALUE + MIN_WORDTRACK_SIZE + 6)

#define INDEXFILE_FLAG_IS_OPEN                   0x0001u
#define INDEXFILE_FLAG_WAS_OPEN                  0x0002u
#define INDEXFILE_FLAG_FILE_OFFSETS_ALLOCED      0x0004u
#define INDEXFILE_FLAG_FILE_STRUCTURES_ALLOCED   0x0008u

#define iffNoIndexInfo              0x0001
#define iffNoWordTrack              0x0002
#define iffNoStopWords              0x0004
#define iffNoValidWords             0x0008
#define iffNoFileOffsets            0x0010
#define iffNoFileStructures         0x0020
#define iffDontRecode               0x0040

void ifInit( struct zcontext_t *cnt, struct indexfile_t *pif);
void ifClose( struct indexfile_t *pif, Boolean virt);
#ifdef CHECK
Boolean ifSeek( struct indexfile_t *pif, zoff_t offset);
zoff_t ifGetSize( struct indexfile_t *pif );
#else
#define ifSeek(f,o) zFileObjectSeek( (f)->file, (o))
#define ifGetSize(f) zFileObjectSize( (f)->file, False)
#endif
unsigned char ifChecksum( const unsigned char *header, const unsigned char *offsets);
void ifPrepareFileMemory( struct indexfile_t *pif, unsigned int flags);
void ifCopy( struct indexfile_t *dest, struct indexfile_t *src);

void ifSetInfo( struct indexfile_t *pif, const char *indexName,
    const char *indexDescription, const char *indexPointer,
    const char *indexAdmin, Boolean doAlloc);
Boolean ifWriteOpen( struct zcontext_t *cnt, struct indexfile_t *pif,
    const char *fileName, const char *fileAlias);
Boolean ifWriteHeader( struct indexfile_t *pif, Boolean realWork);
Boolean ifWriteInfo( struct indexfile_t *pif, const char *indexName,
    const char *indexDescription, const char *indexPointer, const char *indexAdmin);
Boolean ifWriteFileOffsets( struct indexfile_t *pif );
Boolean ifWriteFileStructures( struct indexfile_t *pif );
Boolean ifWriteStopWords( struct indexfile_t *pif );
Boolean ifWriteValidWords( struct indexfile_t *pif );
Boolean ifWriteWordTrack( struct indexfile_t *pif );
Boolean ifStartSection( struct indexfile_t *pif, int section);
Boolean ifEndSection( struct indexfile_t *pif, int section);

Boolean ifReadOpen( struct zcontext_t *cnt, struct indexfile_t *pif,
    const char *fileName, const char *fileAlias, unsigned int flags);
zoff_t ifGetFileOffset( struct indexfile_t *pif, _fn_t fileno);
zoff_t ifFollowWordTrack( struct indexfile_t *pif, const char *word, Boolean isPattern);

/* File info */
struct flu_docentry_t;
Boolean ifReadFileInfo( struct indexfile_t *pif, _fn_t filenum,
    struct flu_docentry_t *de, Boolean full);

#define ifGetFileStructure(pif,fn) \
    ((_st_t) ((pif)->fileStructures[2*(fn)-2] | ((pif)->fileStructures[2*(fn)-1] << 8)))

#define ifSetFileStructure(pif,fn,st) \
    do                                \
    {                                 \
      (pif)->fileStructures[2*(fn)-2] = (unsigned char) (st); \
      (pif)->fileStructures[2*(fn)-1] = (unsigned char) ((st) >> 8); \
    } while( 0 )

#define ifSetFileOffset(pif,fn,ofs) \
      zSetLong( &(pif)->fileOffsets[4*(fn)-4], (ofs), INDEX_FILE_ENDIAN);

/***************************************************************************/
/*                                                                         */
/* Doc entry                                                               */
/*                                                                         */
/***************************************************************************/

#define MAX_DOC_ENTRY_SIZE             (16*1024)

struct flu_docentry_t
{
  char buf[MAX_DOC_ENTRY_SIZE];
  zoff_t offset;
  int length;
  int filled;
  ztime_t lastModified;
  zoff_t size;
  char *url;
  int urlLength;
  char *title;
  int titleLength;
  char *content;
  int contentLength;
  Boolean contentAll;
};

void fluDocEntryInit( struct flu_docentry_t *de );
Boolean fluDocEntryRead( struct zcontext_t *cnt, struct flu_docentry_t *de,
    struct zfileobject_t *fo, FILE *stream, zoff_t offset, int length,
    Boolean full, const char *table);

void fluDocEntryAddAttribs( struct flu_docentry_t *de,
    zoff_t size, ztime_t lastModified, const char *url, const char *title,
    const char *content, Boolean allContent, const char *table);
int fluDocEntryWrite( struct zcontext_t *cnt, struct flu_docentry_t *de,
    FILE *stream, zoff_t *poffset);

#ifdef __cplusplus
}
#endif

#endif
