/*
    FLUIdS - local search system
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstdio.h" /* <stdio.h> */
#include "_pstring.h" /* <string.h> */
#include <assert.h>

#include "zcontext.h"
#include "zerror.h"
#include "zstdlib.h"

#include "indxfile.h"

void fluDocEntryAddAttribs( struct flu_docentry_t *de,
    zoff_t size, ztime_t lastModified, const char *url, const char *title,
    const char *content, Boolean allContent, const char *table)
{
  de->size = size;
  de->lastModified = lastModified;
  de->contentAll = allContent;

  zSetLong( (unsigned char *) &de->buf[0], size, INDEX_FILE_ENDIAN);
  zSetLong( (unsigned char *) &de->buf[4], lastModified, INDEX_FILE_ENDIAN);
  de->filled = 8;

#define ADD_CHAR(x); \
    if( de->filled < MAX_DOC_ENTRY_SIZE-1 ) de->buf[de->filled++] = (x);

#define ADD_TCHAR(x); \
    if( de->filled < MAX_DOC_ENTRY_SIZE-1 ) \
    {                 \
      register char c = (x); \
      if( (c & 0x80) != 0 && table != NULL ) c = table[c & 0x7f]; \
      if( de->filled < MAX_DOC_ENTRY_SIZE-1 ) de->buf[de->filled++] = c; \
    }

#define ADD_STRING(x); \
    {                  \
      register const char *string = ((x) == NULL) ? "" : (x); \
      while( *string != '\0' ){ ADD_TCHAR( *string ); string++; } \
    }

  ADD_STRING( url );
  ADD_CHAR( '\n' );
  ADD_STRING( title );
  ADD_CHAR( allContent ? '\n' : '\r' );
  ADD_STRING( content );
  de->buf[de->filled++] = '\0';

#undef ADD_VCHAR
#undef ADD_TCHAR
#undef ADD_STRING
}

int fluDocEntryWrite( struct zcontext_t *cnt, struct flu_docentry_t *de,
    FILE *stream, zoff_t *poffset)
{
#ifdef DEBUG
  assert( de != NULL );
  assert( de->filled >= 8+3 );
#endif

  if( fseek( stream, 0, SEEK_END) != 0 )
  {
    cnt->printError( cnt, zerTempFileSeek, NULL);
    return -1;
  }

  if( (*poffset = ftell( stream )) < 0 )
  {
    cnt->printError( cnt, zerTempFileTell, NULL);
    return -1;
  }

  if( fwrite( de->buf, de->filled, 1, stream) != 1 )
  {
    cnt->printError( cnt, zerTempFileWrite, NULL);
    return -1;
  }

  de->offset = *poffset;
  de->length = de->filled;
  return de->filled;
}
