/*
    FLUIdS - local search system
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstdio.h" /* <stdio.h> */
#include "_pstring.h" /* <string.h> */

#include "zcontext.h"
#include "zerror.h"
#include "zfile.h"
#include "zstdlib.h"

#include "indxfile.h"

void fluDocEntryInit( struct flu_docentry_t *de )
{
  *de->buf = '\0';
  de->filled = 0;
  de->lastModified = 0;
  de->size = -1;
  de->url = de->title = de->content = de->buf;
  de->urlLength = de->titleLength = de->contentLength = 0;
  de->contentAll = True;
}

Boolean fluDocEntryRead( struct zcontext_t *cnt, struct flu_docentry_t *de,
    struct zfileobject_t *fo, FILE *stream, zoff_t offset, int length,
    Boolean full, const char *table)
{
  char lastc, endc;

  if( length >= MAX_DOC_ENTRY_SIZE ) length = MAX_DOC_ENTRY_SIZE-1;

  if( stream != NULL )
  {
    if( fseek( stream, offset, SEEK_SET) != 0 )
    {
      cnt->printError( cnt, zerTempFileSeek, NULL);
      return False;
    }

    if( fread( de->buf, length, 1, stream) != 1 )
    {
      cnt->printError( cnt, zerTempFileRead, NULL);
      return False;
    }
  }
  else
  {
    if( !zFileObjectSeek( fo, offset) ) return False;
    if( zFileObjectRead( fo, (unsigned char *) de->buf, length, False) == NULL ) return False;
  }

  endc = de->buf[length];
  de->buf[length] = '\0';
  de->offset = offset;
  de->length = length;
  de->size = (zoff_t) zGetLong( (unsigned char *) &de->buf[0], INDEX_FILE_ENDIAN);
  de->lastModified = (ztime_t) zGetLong( (unsigned char *) &de->buf[4], INDEX_FILE_ENDIAN);

#define GET_STRING(string,shift,length) \
  {                                     \
    register unsigned char *buf = (unsigned char *) de->buf, c; \
    register int filled = (shift);      \
    (string) = &de->buf[filled];        \
    while( (c = buf[filled]) != '\0' && c != '\n' && c != '\r' ) \
    {                                   \
      if( c < ' ' )                     \
        c = ' ';                        \
      else if( (c & 0x80) != 0 && table != NULL ) \
        c = ((unsigned char *) table)[ (c & 0x7f) ]; \
      buf[filled] = c;                  \
      filled++;                         \
    }                                   \
    lastc = (char) c;                   \
    (length) = filled - (shift);        \
    buf[filled] = '\0';                 \
    de->filled = filled + 1;            \
  }

/* URL */
  GET_STRING( de->url, 8, de->urlLength);
  de->title = de->content = &de->buf[de->filled-1];
  de->titleLength = de->contentLength = 0;
  de->contentAll = True;

  if( full && lastc != '\0' )
  {
/* Title */
    GET_STRING( de->title, de->filled, de->titleLength);

/* Content */
    if( lastc != '\0' )
    {
      de->contentAll = (Boolean) (lastc != '\r');
      GET_STRING( de->content, de->filled, de->contentLength);
      if( de->contentAll ) de->contentAll = (Boolean) (lastc == '\0' || endc == '\0');
    }
  }

#undef GET_STRING

  return True;
}
