/*
    FLUIdS - local search system
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstdio.h" /* <stdio.h> */
#include "_pstring.h" /* <striong.h> */
#ifdef CHECK
#include <assert.h>
#endif

#include "zcontext.h"
#include "zstdlib.h"

#include "cfg.h"
#include "defs.h"
#include "error.h"
#include "indxfile.h"

Boolean ifReadFileInfo( struct indexfile_t *pif, _fn_t filenum,
    struct flu_docentry_t *de, Boolean full)
{
  zoff_t offset, nextOffset;
  int length;

#ifdef CHECK
  assert( pif != NULL );
  assert( pif->file != NULL );
  assert( filenum > 0 );
  assert( filenum <= pif->header.fileCount );
  assert( de != NULL );
#endif

  /* ந樠㥬  ࠧ  docentry */
  fluDocEntryInit( de );

  /* ᭨  ⥪饣 䠩  ᫥饣    浪 */
  if( (offset = ifGetFileOffset( pif, filenum)) < 0 ) return False;
  if( filenum >= pif->header.fileCount )
    nextOffset = pif->offsets[OFFSET_FILES_END];
  else if( (nextOffset = ifGetFileOffset( pif, filenum+1)) < 0 )
    return False;

  /*     ⥪饣 䠩; ᫨  ᫨誮 쪠 -
      訡 */
  if( (length = (int) (nextOffset - offset)) < 8+3 )
  {
    pif->context->printError( pif->context, errIndexFileOffsets, pif->alias);
    return False;
  }

  /* ⠥ ਡ ⥪饣 䠩 */
  if( !fluDocEntryRead( pif->context, de, pif->file, NULL, offset, length, full,
#if defined( RUSSIAN_SUPPORT ) && defined( RUSSIAN_RELEASE )
         pif->recodeTable
#else
         NULL
#endif
                         ) ) return False;

  /* ,   ! */
  return True;
}
