/*
    FLUIdS - local search system
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstdio.h" /* <stdio.h> */
#include "_pstring.h" /* <string.h> */
#ifdef CHECK
#include <assert.h>
#endif

#include "zcontext.h"
#include "zalloc.h"
#include "zcharset.h"
#include "zerror.h"
#include "zfile.h"
#include "zstdlib.h"

#include "cfg.h"
#include "defs.h"
#include "error.h"
#include "indio.h"
#if defined( FLUIDS43 )
#include "indxdir.h"
#include "indxio.h"
#endif
#include "wtrack.h"
#include "indxfile.h"

const unsigned zint_t ifErrorCodes[ZFILEOBJECT_ERRORCODE_LAST] =
{
  errIndexFileOpen,
  errIndexFileSeek,
  errIndexFileTell,
  zerFileStat,
  zerZeroLengthFile,
  zerFileMmap,
  errIndexFileRead,
  errIndexFileWrite,
  zerUnexpectedFileEnd,
  errIndexFileFormat
};

void ifInit( struct zcontext_t *cnt, struct indexfile_t *pif)
{
  ZEROFILL( pif, sizeof( struct indexfile_t ));
  pif->context = cnt;
  wtInit( cnt, &pif->wordTrack);
#if defined( FLUIDS43 )
  idirReadListInit( cnt, &pif->dirList);
  FLU_ENTRY_INIT( cnt, &pif->dirEntry);
#endif
  ioInitWordEntry( cnt, &pif->wordEntry);
  pif->file = NULL;

  pif->header.id[0] = 'F';
  pif->header.id[1] = 'L';
  pif->header.id[2] = 'U';
  pif->header.id[3] = 0;

  pif->header.version = INDEX_VERSION;
  pif->header.subversion = INDEX_SUBVERSION;

#if defined( RUSSIAN_SUPPORT ) && defined( RUSSIAN_RELEASE )
  pif->charset = cnt->localCharset;
  pif->header.charset = zToGlobalCharset( cnt->localCharset );
  pif->recodeTable = NULL;
  pif->convTable = NULL;
#else
  pif->header.charset = ZGCS_NONE;
#endif
}

void ifClose( struct indexfile_t *pif, Boolean virt)
{
  if( pif->file != NULL )
  {
    zFileObjectClose( pif->file );
    pif->file = NULL;
  }

  if( !virt )
  {
    if( pif->alias != pif->name ){ ZFREE( pif->context, pif->alias); } else pif->alias = NULL;
    ZFREE( pif->context, pif->name);
    if( zCheckFlags( pif->flags, INDEXFILE_FLAG_FILE_OFFSETS_ALLOCED) )
      zFree( pif->context, pif->fileOffsets);
    if( zCheckFlags( pif->flags, INDEXFILE_FLAG_FILE_STRUCTURES_ALLOCED) )
      zFree( pif->context, pif->fileStructures);
    pif->fileOffsets = pif->fileStructures = NULL;
#if defined( FLUIDS43 )
    idirReadListFree( &pif->dirList );
    FLU_ENTRY_FREE( &pif->dirEntry );
#endif
    wtFree( &pif->wordTrack );

    if( pif->infoAlloced )
    {
      _ZFREE( pif->context, pif->indexName);
      _ZFREE( pif->context, pif->indexDescription);
      _ZFREE( pif->context, pif->indexPointer);
      _ZFREE( pif->context, pif->indexAdmin);
    }
    pif->indexName = pif->indexDescription = pif->indexPointer = pif->indexAdmin = NULL;
    pif->infoAlloced = False;

    zUnsetFlags( pif->flags, INDEXFILE_FLAG_IS_OPEN);
  }
}

#ifdef CHECK
Boolean ifSeek( struct indexfile_t *pif, zoff_t offset)
{
  assert( pif != NULL );
  assert( pif->file != NULL );
  assert( offset >= 0 );

  return zFileObjectSeek( pif->file, offset);
}

zoff_t ifGetSize( struct indexfile_t *pif )
{
  assert( pif != NULL );
  assert( pif->file != NULL );

  return zFileObjectSize( pif->file, False);
}
#endif

unsigned char ifChecksum( const unsigned char *header, const unsigned char *offsets)
{
  int i;
  unsigned zint_t sum = 0;

#ifdef CHECK
  assert( header != NULL );
  assert( offsets != NULL );
#endif

  for( i = 0; i < INDEX_CHECKSUM_LENGTH; i++) sum += header[i];
  for( i = 0; i < INDEX_OFFSET_COUNT*4; i++) sum += offsets[i];
  return (unsigned char) (~sum);
}

void ifPrepareFileMemory( struct indexfile_t *pif, unsigned int flags)
{
  size_t byteCount;

  if( pif->header.fileCount == 0 ) return;

  if( !zCheckFlags( pif->file->flags, zfoMapped) )
  {
    if( !zCheckFlags( flags, iffNoFileOffsets) )
    {
      byteCount = (unsigned int) pif->header.fileCount * 4;
      ZFREE( pif->context, pif->fileOffsets);
      if( byteCount > 0 )
      {
        pif->fileOffsets = (unsigned char *) zMalloc( pif->context, byteCount);
        ZEROFILL( pif->fileOffsets, byteCount);
      }
      zSetFlags( pif->flags, INDEXFILE_FLAG_FILE_OFFSETS_ALLOCED);
    }

    if( !zCheckFlags( flags, iffNoFileStructures) )
    {
      byteCount = (unsigned int) pif->header.fileCount * 2;
      ZFREE( pif->context, pif->fileStructures);
      if( byteCount > 0 )
      {
        pif->fileStructures = (unsigned char *) zMalloc( pif->context, byteCount);
        ZEROFILL( pif->fileStructures, byteCount);
      }
      zSetFlags( pif->flags, INDEXFILE_FLAG_FILE_STRUCTURES_ALLOCED);
    }
  }
}

void ifCopy( struct indexfile_t *dest, struct indexfile_t *src)
{
  memcpy( dest, src, sizeof(struct indexfile_t));
  dest->file = &dest->fileObject;
}
