/*
    FLUIdS - local search system
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef __INDXDIR_A
#define __INDXDIR_A

#ifndef __ZDEFS_A
#include "zdefs.h"
#endif

#ifndef __DEFS_A
#include "defs.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif

#if defined( FLUIDS43 )
#define fdeNoOffset                    0x40u
#define fdeNoCount                     0x80u

struct indexfile_t;

/***************************************************************************/
/*                                                                         */
/*  W-DirList                                                              */
/*                                                                         */
/***************************************************************************/

struct idir_witem_t;
struct idir_wblock_t;
struct flu_docmap_t;

struct idir_wlist_t
{
  struct zcontext_t *context;
  struct idir_wblock_t *heap;
  struct idir_witem_t *head;
  struct flu_docmap_t *map;
};

void idirWriteListInit( struct zcontext_t *cnt, struct idir_wlist_t *dl,
    struct flu_docmap_t *map);
void idirWriteListFree( struct idir_wlist_t *dl );
Boolean idirWriteListAdd( struct idir_wlist_t *dl, const char *url, _fn_t filenum);

Boolean idirWriteListWrite( struct indexfile_t *pif, struct idir_wlist_t *dl);

/***************************************************************************/
/*                                                                         */
/*  R-DirList                                                              */
/*                                                                         */
/***************************************************************************/

struct idir_ritem_t
{
  const char *name;
  struct idir_ritem_t *next;
  struct idir_ritem_t *down;
  _fn_t startNum;
  _fn_t count;
  unsigned int nameLength;
  zoff_t offset;
};

struct idir_rblock_t;

struct idir_rlist_t
{
  struct zcontext_t *context;
  struct idir_rblock_t *blocks;
  struct idir_ritem_t *heap;
  struct idir_ritem_t *head;
  struct idir_ritem_t *tmp;
};

void idirReadListInit( struct zcontext_t *cnt, struct idir_rlist_t *dl);
void idirReadListFree( struct idir_rlist_t *dl );

void idirReadListItemFree( struct idir_rlist_t *dl, struct idir_ritem_t *id);
void idirReadListChainFree( struct idir_rlist_t *dl, struct idir_ritem_t *id);

Boolean idirReadListDownRead( struct indexfile_t *pif,
    struct idir_ritem_t *up, struct idir_ritem_t **phead, zoff_t offset);
Boolean idirReadListBounds( struct indexfile_t *pif, 
    const char *name, _fn_t *pstartNum, _fn_t *pcount);
#endif

#ifdef __cplusplus
}
#endif

#endif
