/*
    FLUIdS - local search system
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstdio.h" /* <stdio.h> */
#include "_pstring.h" /* <string.h> */
#include <assert.h>

#include "zcontext.h"
#include "zalloc.h"
#include "zerror.h"

#include "error.h"
#include "indio.h"

void ioAddEntryWord( struct wordentry_t *we, const char *word)
{
  ioReinitWordEntry( we );
  we->wordLength = strlen( word );
  we->filled = we->wordLength + 1;
  IO_RESIZE_BUFFER( we, we->filled);

  memcpy( we->word, word, we->wordLength);
  we->word[we->wordLength] = WORD_END;
}

void ioAddEntryItem( struct wordentry_t *we, _st_t structure, _fn_t filenum, _rn_t rank)
{
  _fn_t lastFilenum = filenum;

#ifdef CHECK
  assert( filenum > 0 );
#endif

  if( we->fileCount > 0 )
  {
#ifdef CHECK
    assert( we->filled > we->wordLength + 1 );
    assert( we->lastFilenum < filenum );
#endif
    filenum -= we->lastFilenum;
  }
#ifdef CHECK
  else
    assert( we->filled == we->wordLength + 1 );
#endif

  filenum--;
  IO_ADD_ITEM( we, structure, filenum, rank);

  we->lastFilenum = lastFilenum;
  we->fileCount++;
}

#if defined( __BC__ ) && defined( __WIN32__ )
inline unsigned int bcdummy( unsigned int v )
{
  return v;
}
#endif

void ioGetLastFilenum( struct wordentry_t *we )
{
  _fn_t filenum, fn, tmp;
  register size_t len;
  register unsigned char *buf = we->buffer;
  _fn_t fileCount;

  for( filenum = 0, fileCount = 0, len = we->wordLength + 1; len < we->filled; )
  {
    IO_SKIP_STRUCTURE( buf, len);
#if defined( __BC__ ) && defined( __WIN32__ )
    len = bcdummy( len );
#endif
    IO_DECODE_NUMBER( fn, buf, len, tmp);
    IO_SKIP_NUMBER( buf, len);

    filenum += fn;
    filenum++;

    fileCount++;
  }

  we->lastFilenum = filenum;
  we->fileCount = fileCount;

#ifdef CHECK
  assert( fileCount > 0 );
#endif
}

Boolean ioWriteWordEntry( struct wordentry_t *we, FILE *stream, const char *fileName)
{
  size_t entrySize = we->filled;

#ifdef CHECK
  assert( we->wordLength > 0 );
  assert( we->filled > we->wordLength + 3 );
  assert( we->fileCount > 0 );
#endif

#undef IO_UNSUCCESS_ACTION
#define IO_UNSUCCESS_ACTION          goto write_error
  IO_WRITE_NUMBER( entrySize, stream);

  if( fwrite( we->buffer, we->filled, 1, stream) != 1 )
  {
    write_error: we->context->printError( we->context, (fileName == NULL) ?
      zerTempFileWrite : errIndexFileWrite, fileName);
    return False;
  }

  return True;
}
