/*
    FLUIdS - local search system
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstdio.h" /* <stdio.h> */
#include "_pstring.h" /* <string.h> */
#include <assert.h>

#include "zcontext.h"
#include "zalloc.h"
#include "zerror.h"
#include "zfile.h"

#include "error.h"
#include "indio.h"

Boolean ioReadWordEntry( struct wordentry_t *we, struct zfileobject_t *fo,
   FILE *stream, const char *fileName)
{
  Boolean mapped = (Boolean) (fo != NULL && zCheckFlags( fo->flags, zfoMapped));
  size_t entrySize, size, len;
  unsigned char *s;

  ioReinitWordEntry( we );

#if defined( USE_MMAP ) && defined( HAVE_MMAP )
  if( mapped )
  {
    size_t tmp;
    IO_DECODE_NUMBER( entrySize, fo->addr, fo->offset, tmp);
  }
  else
#endif
  {
#undef IO_UNSUCCESS_ACTION
#define IO_UNSUCCESS_ACTION          goto read_error
    IO_READ_NUMBER( entrySize, stream);
  }

  if( entrySize < 5 /* || entrySize > we->maxSize */ ) goto format_error;
  if( we->stopOffset > 0 )
  {
    zoff_t offset;
    if( fo != NULL )
      offset = zFileObjectTell( fo );
    else if( (offset = ftell( stream )) < 0 )
    {
      we->context->printError( we->context, (fileName == NULL) ?
        zerTempFileTell : errIndexFileTell, fileName);
      return False;
    }
    if( offset + (zoff_t) entrySize > we->stopOffset ) goto format_error;
  }

  if( !mapped )
  {
    size = entrySize + 4;
    IO_RESIZE_BUFFER( we, size);
#ifdef CHECK
    assert( entrySize+4 <= we->size );
#endif
  }

  if( fo != NULL )
  {
    unsigned char *buffer;
    if( (buffer = zFileObjectRead( fo, we->buffer, entrySize, True)) == NULL ) return False;
    we->buffer = buffer;
  }
  else
    if( fread( we->buffer, entrySize, 1, stream) != 1 )
    {
      read_error: we->context->printError( we->context, (fileName == NULL) ?
        zerTempFileRead : errIndexFileRead, fileName);
      return False;
    }

  we->filled = entrySize;

  if( !mapped )
  {
    we->buffer[entrySize] = we->buffer[entrySize+1] =
      we->buffer[entrySize+2] = we->buffer[entrySize+3] = '\0';
  }

  if( (s = (unsigned char *) memchr( we->buffer, WORD_END, entrySize)) == NULL )
  {
    format_error:
#ifdef CHECK
    assert( fileName != NULL );
#endif
    we->context->printError( we->context, errIndexFileFormat, fileName);
    return False;
  }
  else
  {
    we->wordLength = (size_t) (s - we->buffer);
    if( we->wordLength == 0 || we->filled < we->wordLength+4 ) goto format_error;
    len = ZMIN( we->wordLength, MAX_WORD_SIZE);
    if( mapped )
    {
      memcpy( we->wordBuffer, we->buffer, len);
      we->wordBuffer[len] = '\0';
      we->word = we->wordBuffer;
    }
    else
    {
      we->buffer[len] = '\0';
      we->word = (char *) we->buffer;
    }
  }

  return True;
}
