/*
    FLUIdS - local search system
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef __INDIO_H
#define __INDIO_H

#ifndef __ZDEFS_A
#include "zdefs.h"
#endif

#ifndef ___PSTDIO_A
#include "_pstdio.h"
#endif

#ifndef __DEFS_A
#include "defs.h"
#endif

#ifndef __STRUCTUR_A
#include "structur.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif

#if SIZEOF_INT < 4
#define ENTRY_BUFFER_STEP     512
#else
#define ENTRY_BUFFER_STEP     (8*1024)
#endif
#define ENTRY_BUFFER_SIZE     (2*ENTRY_BUFFER_STEP)

#define WORD_END              ' '

struct wordentry_t
{
  struct zcontext_t *context;
  Boolean alloced;
  unsigned char *buffer;
  char wordBuffer[MAX_WORD_SIZE+1];
  char *word;
  size_t size;
  size_t filled;
  size_t wordLength;

/* for writing */
  _fn_t fileCount;
  _fn_t lastFilenum;

/* for reading */
  zoff_t stopOffset;
};

#define IO_RESIZE_BUFFER(we,ns);              \
    if( (we)->size == 0 )                     \
    {                                         \
      if( ((we)->size = (ns)) <= ENTRY_BUFFER_SIZE ) \
        (we)->size = ENTRY_BUFFER_SIZE;       \
      else if( ((we)->size % ENTRY_BUFFER_STEP) != 0 ) \
        (we)->size = (((we)->size / ENTRY_BUFFER_STEP) + 1) * ENTRY_BUFFER_STEP; \
      (we)->buffer = (unsigned char *) zMalloc( (we)->context, (we)->size); \
    }                                         \
    else if( (ns) > (we)->size )              \
    {                                         \
      (we)->size = (ns);                      \
      if( ((we)->size % ENTRY_BUFFER_STEP) != 0 ) \
        (we)->size = (((we)->size / ENTRY_BUFFER_STEP) + 1) * ENTRY_BUFFER_STEP; \
      (we)->buffer = (unsigned char *) zRealloc( (we)->context, (we)->buffer, (we)->size); \
    }                                         \
    (we)->word = (char *) (we)->buffer;       \
    (we)->alloced = True;

#define IO_FREE_BUFFER(we);                   \
    if( (we)->alloced && (we)->buffer != NULL ) zFree( (we)->context, (we)->buffer); \
    (we)->buffer = NULL;                      \
    (we)->word = NULL;                        \
    (we)->size = 0;                           \
    (we)->alloced = False;

#define IO_ENCODE_NUMBER(num,buf,len);        \
    (buf)[(len)++] = (num) & 0x7f;            \
    for( ;; )                                 \
    {                                         \
      (num) >>= 7;                            \
      if( (num) == 0 ) break;                 \
      (buf)[(len)++] = ((num) & 0x7f) | 0x80; \
    }

#define IO_ENCODE_STRUCTURE(st,buf,len);      \
    if( HAS_CHARACTERISTIC( st ) )            \
    {                                         \
      int count;                              \
      GET_AREA_COUNT( count, (st));           \
      if( count <= 1 )                        \
      {                                       \
        SHRINK_STRUCTURE(st);                 \
        (buf)[(len)++] = (unsigned char) (st); \
      }                                       \
      else                                    \
      {                                       \
        FIXUP_STRUCTURE( st );                \
        (buf)[(len)++] = (unsigned char) ((st) >> 8); \
        (buf)[(len)++] = (unsigned char) (st); \
      }                                       \
    }                                         \
    else                                      \
    {                                         \
      zUnsetFlagsEx( (st), CHIC_MASK, _st_t); \
      (buf)[(len)++] = (unsigned char) (st);  \
    }

#define IO_DECODE_NUMBER(num,buf,len,x);      \
    (x) = ((const unsigned char *) (buf))[(len)++]; \
    (num) = ((x) & 0x7f);                     \
    if( ((x) & 0x80) != 0 )                   \
      do                                      \
      {                                       \
        (num) <<= 7;                          \
        (x) = ((const unsigned char *) (buf))[(len)++]; \
        (num) |= ((x) & 0x7f);                \
      }while( ((x) & 0x80) != 0 );

#define IO_DECODE_STRUCTURE(st,buf,len);      \
    (st) = (buf)[(len)++];                    \
    if( zCheckFlags( (st), CHIC_MASK) )       \
    {                                         \
      int count;                              \
      GET_AREA_COUNT( count, (st));           \
      if( count > 1 )                         \
      {                                       \
        zSetFlags( (st), (_st_t) ((buf)[(len)++] << 8)); \
        UNFIXUP_STRUCTURE( st );              \
      }                                       \
      else                                    \
      {                                       \
        EXTEND_STRUCTURE((st),(st));          \
      }                                       \
    }                                         \
    else                                      \
    {                                         \
      EXTEND_STRUCTURE((st),(st));            \
    }

#define IO_SKIP_NUMBER(buf,len);              \
    if( ((buf)[(len)] & 0x80) != 0 )          \
      do{ (len)++; }while( ((buf)[(len)] & 0x80) != 0 ); \
    (len)++;

#define IO_SKIP_STRUCTURE(buf,len);           \
    {                                         \
      _st_t st = (buf)[(len)];                \
      if( zCheckFlags( (st), CHIC_MASK) )     \
      {                                       \
        int count;                            \
        GET_AREA_COUNT( count, st);           \
        if( count > 1 ) (len)++;              \
      }                                       \
    }                                         \
    (len)++;


#define _IO_ADD_ITEM(we,st,fn,rn,buf,len);    \
    (len) = 0;                                \
    IO_ENCODE_NUMBER((rn),(buf),(len));       \
    IO_ENCODE_NUMBER((fn),(buf),(len));       \
    IO_ENCODE_STRUCTURE((st),(buf),(len));    \
    IO_PUT_RBUFFER((we),(buf),(len));

#define IO_ADD_ITEM(we,st,fn,rn);             \
    {                                         \
      unsigned char buf[32];                  \
      int len;                                \
      _IO_ADD_ITEM(we,st,fn,rn,buf,len);      \
    }

#define IO_PUT_RBUFFER(we,buf,len);           \
    IO_RESIZE_BUFFER( we, len + (we)->filled); \
    while( (len) > 0 ) (we)->buffer[(we)->filled++] = (buf)[--(len)];


/* #define IO_UNSUCCESS_ACTION    return False */

#define _IO_READ_NUMBER(num,stream,x);        \
    (num) = 0;                                \
    do                                        \
    {                                         \
      if( fread( &(x), 1, 1, (stream)) != 1 ){ IO_UNSUCCESS_ACTION; } \
      (num) <<= 7;                            \
      (num) += ((x) & 0x7f);                  \
    }while( ((x) & 0x80) != 0 );

#define IO_READ_NUMBER(num,stream);           \
    {                                         \
      unsigned char x;                        \
      _IO_READ_NUMBER(num,stream,x);          \
    }

#define _IO_WRITE_NUMBER(num,stream,buf,len); \
    (len) = 0;                                \
    IO_ENCODE_NUMBER(num,buf,len);            \
    while( (len) > 0 )                        \
      if( fwrite( &(buf)[--(len)], 1, 1, (stream)) != 1 ) \
        IO_UNSUCCESS_ACTION;

#define IO_WRITE_NUMBER(num,stream);          \
    {                                         \
      unsigned char buf[16];                  \
      int len;                                \
      _IO_WRITE_NUMBER(num,stream,buf,len);   \
    }

#define IO_NUMBER_LENGTH(n,l);                \
    {                                         \
      unsigned zint_t _num = (n);             \
      (l) = 0;                                \
      do{ _num >>= 7; (l)++; }while( _num != 0 ); \
    }

#define IO_NUMBER_LENGTH_ADD(n,l);            \
    {                                         \
      unsigned zint_t _num = (n);             \
      do{ _num >>= 7; (l)++; }while( _num != 0 ); \
    }

void ioInitWordEntry( struct zcontext_t *cnt, struct wordentry_t *we);
void ioReinitWordEntry( struct wordentry_t *we );

void ioAddEntryWord( struct wordentry_t *we, const char *word);
void ioAddEntryItem( struct wordentry_t *we, _st_t structure, _fn_t filenum, _rn_t rank);

void ioGetLastFilenum( struct wordentry_t *we );

Boolean ioReadWordEntry( struct wordentry_t *we, struct zfileobject_t *fo,
   FILE *stream, const char *fileName);
Boolean ioWriteWordEntry( struct wordentry_t *we, FILE *stream, const char *fileName);

#ifdef __cplusplus
}
#endif

#endif
