/*
    FLUIdS - local search system
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef __INDEXER__A
#define __INDEXER__A

#ifndef __ZDEFS_A
#include "zdefs.h"
#endif

#include <setjmp.h>

#ifndef __ZCONTEXT_A
#include "zcontext.h"
#endif

#ifndef __ZCOLL_A
#include "zcoll.h"
#endif

#ifndef __ZFILE_A
#include "zfile.h"
#endif

#ifndef __ZTIME_A
#include "ztime.h"
#endif

#ifndef __CFG_A
#include "cfg.h"
#endif

#ifndef __FLUDATA_A
#include "fludata.h"
#endif

#ifndef __DOCMAP_A
#include "docmap.h"
#endif

#ifndef __INDXDIR_A
#include "indxdir.h"
#endif

#ifndef __INDXFILE_A
#include "indxfile.h"
#endif

#ifndef __INDXWORD_A
#include "indxword.h"
#endif

//#ifndef __INDIO_A
//#include "indio.h"
//#endif

#ifdef __cplusplus
extern "C" {
#endif

/***************************************************************************/
/*                                                                         */
/*  Document list                                                          */
/*                                                                         */
/***************************************************************************/

#define FLU_INDEXER_DOCFOOTPRINT_BLOCK_SIZE      199
#define FLU_INDEXER_DOCHASH_SIZE                 (1 << 10)
#define FLU_INDEXER_DOCHASH(x)                   ((int) ((x) & (FLU_INDEXER_DOCHASH_SIZE-1)))

struct flu_doclist_footprint_t;
struct flu_doclist_fingerprint_t;
struct flu_doclist_block_t;
struct flu_entryitem_t;
struct flu_entryitem_block_t;

struct flu_doclist_t
{
  struct zcontext_t *context;
  struct flu_doclist_footprint_t *docHash[FLU_INDEXER_DOCHASH_SIZE];
  struct flu_doclist_block_t *docBlocks;
  struct zsetcoll_t files;
  struct zdatacoll_t indexes;
  struct ztempfile_t docSwap;
  struct flu_entryitem_block_t *entryBlocks;
  struct flu_entryitem_t *entryHeap;
  unsigned zint_t generalCount;
};

Boolean _fluDoclistInit( struct zcontext_t *cnt, struct flu_doclist_t *dl);
void _fluDoclistFree( struct flu_doclist_t *dl );

/***************************************************************************/
/*                                                                         */
/*  Indexed document                                                       */
/*                                                                         */
/***************************************************************************/

struct flu_indexer_doc_t
{
  _fn_t fnum;
  zoff_t offset;
  int length;
  _st_t structure;
  short inum;
  unsigned zint_t wordCount;
};

Boolean _fluIndexerDocumentFinish( struct flu_indexer_t *fi,
    _fn_t fnum, zoff_t offset, int length, _st_t structure, short inum);

/***************************************************************************/
/*                                                                         */
/*  Indexer data                                                           */
/*                                                                         */
/***************************************************************************/

struct flu_indexer_doccurrent_t
{
  _fn_t fnum;
  struct flu_indexer_doc_t *info;
  struct flu_doclist_footprint_t *fp;
  unsigned zint_t crc32;
  ztime_t lastModified;
  zoff_t size;
  const char *url;
  Boolean urlSafe;
  char title[MAX_TITLE_LENGTH+1];
  /* int titleLength; */
  char content[MAX_CONTENT_LENGTH+1];
  /* int contentLength; */
  Boolean contentAll;
};

struct flu_indexer_data_t
{
  struct zcontext_t cntData;
  struct fludata_t fluData;
  struct indexfile_t indexFile;
  struct ztimeval_t startTime, endTime;
  jmp_buf jumpBuf;

/* ᮪ ந஢ ᫮ */
  struct iw_wordlist_t wordList[WORD_LIST_SIZE];
  unsigned zint_t memoryVolum;

/* ᮪ ந஢ 䠩  ⥪騩 㥬 㬥 */
  struct flu_indexer_doccurrent_t doc;
  struct flu_doclist_t docList;
#if defined( FLUIDS43 )
  struct idir_wlist_t dirList;
#endif
  struct flu_docmap_t docMap;

/*  */
  struct ztempfile_t *swapList;
  struct ztempfile_t tmpSwap;
  int swapCount;
  int swapCurrent;
  int maxSwapFiles;
};

struct flu_indexer_indexfile_t
{
  struct flu_docmap_t map;
  struct indexfile_t indexFile;
};

void _fluItemMemoryHeapFree( struct flu_doclist_t *dl );

#ifdef __cplusplus
}
#endif

#endif
