/*
    FLUIdS - local search system
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "zcharset.h"

#include "error.h"
#include "indexer.h"
#include "indexer_.h"

Boolean fluIndexerAddIndexFile( struct flu_indexer_t *fi,
    const char *fileName, unsigned int flags)
{
  struct flu_indexer_indexfile_t *ii = NULL;
  struct flu_indexer_indexfile_t indexFile;
  _fn_t i, start, end;
  unsigned int iflags;
  short inum;
  Boolean success;

  /* XXX: 㦭 ᫥, ⮡ inum  뫥  । short' */
  inum = (short) zDataCollectionCount( &fi->ptr->docList.indexes ) + 1;
  success = True;

/* ६  䫠 */
  iflags = 0;
  if( zCheckFlags( flags, fifIgnoreIndexInfo) ) iflags = iffNoIndexInfo;
  if( zCheckFlags( flags, fifIgnoreStopWords) ) iflags = iffNoStopWords;

/*  砩 墠⪨  */
  dmapInit( fi->context, &indexFile.map, 0);
  ifInit( fi->context, &indexFile.indexFile);
  if( setjmp( fi->ptr->jumpBuf ) != 0 )
  {
    if( ii != NULL )
    {
      dmapFree( fi->context, &ii->map);
      ifClose( &ii->indexFile, False);
    }
    else
      ifClose( &indexFile.indexFile, False);
    return False;
  }

/* ஥  䠩. ᫨  ⮩,  㤥   */
  if( !ifReadOpen( fi->context, &indexFile.indexFile, fileName, NULL, iflags) )
    return False;
  if( (_fn_t) indexFile.indexFile.header.fileCount == 0 )
  {
    ifClose( &indexFile.indexFile, False);
    return True;
  }

/* ᫨ ஢  ᮢ  ࠡ祩 - 訡! */
  if( indexFile.indexFile.header.charset != 0 &&
      indexFile.indexFile.header.charset != zToGlobalCharset( fi->context->localCharset ) )
  {
    fi->context->printError( fi->context, errDifferentCharset, fileName);
    ifClose( &indexFile.indexFile, False);
    return False;
  }

/* ᯮ㥬 info' ⮣ ᭮ 䠩 */
  if( !zCheckFlags( flags, fifIgnoreIndexInfo) && fi->pif != NULL &&
      fi->pif->indexName == NULL && fi->pif->indexDescription == NULL &&
      fi->pif->indexPointer == NULL && fi->pif->indexAdmin == NULL )
    ifSetInfo( fi->pif, indexFile.indexFile.indexName,
      indexFile.indexFile.indexDescription, indexFile.indexFile.indexPointer,
      indexFile.indexFile.indexAdmin, False);

/*   䠩   */
  zDataCollectionAdd( &fi->ptr->docList.indexes, &indexFile, 0);
  ii = (struct flu_indexer_indexfile_t *)
	  zDataCollectionElem( &fi->ptr->docList.indexes, inum-1);
  ifCopy( &ii->indexFile, &indexFile.indexFile);

/* ⠥  ந஢ 䠩 */
  start = zSetCollectionCount( &fi->ptr->docList.files );
  for( i = 1; i <= (_fn_t) indexFile.indexFile.header.fileCount; i++)
  {
    struct flu_docentry_t fileInfo;
    if( !ifReadFileInfo( &indexFile.indexFile, i, &fileInfo, False) ||
	  *fileInfo.url == '\0' ) continue;
    if( !fluIndexerDocumentStart( fi, fileInfo.url, fileInfo.size,
	  fileInfo.lastModified, flags | fifUrlSafe) )
    {
      success = False;
      break;
    }
    if( !fluIndexerDocumentAlive( fi ) ) continue;
    if( !_fluIndexerDocumentFinish( fi, i,
           fileInfo.offset, fileInfo.length,
           ifGetFileStructure( &indexFile.indexFile, i),
           zCheckFlags( flags, fifReindexAll) ? -inum : inum) )
    {
      success = False;
      break;
    }
  }
  end = zSetCollectionCount( &fi->ptr->docList.files );

/* ⮦ */
  if( !success )
  {
    /* ⮦ 䠩 ⥬ fnum -> 0 */
    for( i = start+1; i <= end; i++)
    {
      struct flu_indexer_doc_t *doc = (struct flu_indexer_doc_t *) 
        zSetCollectionElem( &fi->ptr->docList.files, i-1);
      doc->fnum = 0;
    }
    fi->ptr->docList.indexes.count--;
  }
  else if( end != start )
  {
    dmapInit( fi->context, &ii->map, (_fn_t) indexFile.indexFile.header.fileCount);
    ii->map.length = ii->map.size;
  }
  else
  {
    ifClose( &indexFile.indexFile, False);
    fi->ptr->docList.indexes.count--;
  }

  return success;
}
