/*
    FLUIdS - local search system
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef __INDEXER_A
#define __INDEXER_A

#ifndef __ZDEFS_A
#include "zdefs.h"
#endif

#ifndef __ZTIME_A
#include "ztime.h"
#endif

#ifndef __DEFS_A
#include "defs.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif

struct indexfile_t;
struct indexword_t;
struct realfile_t;
struct flu_indexer_t;
struct flu_indexer_data_t;

typedef void (*flu_indexer_printerror_t)( struct flu_indexer_t *, unsigned zint_t, const char *);
typedef void (*flu_indexer_memfail_t)( struct flu_indexer_t *, const char *);

struct flu_indexer_t
{
/* ⥪ 樨 */
  struct zcontext_t *context;
  flu_indexer_printerror_t printError;
  flu_indexer_memfail_t memoryFail;
  unsigned zint_t errorCode;
  int allocCount;
  void *info;
  unsigned zint_t maxMemoryVolum;
  const char *tempDir;

/*  䠩,   ந */
  struct indexfile_t *pif;

/* ७  */
  struct flu_indexer_data_t *ptr;
  struct ztimeval_t *startTime;
  struct ztimeval_t *endTime;
};

#define _FLU_INDEXER(cnt)              ((cnt)->info2)
#define FLU_INDEXER(cnt)               ((struct flu_indexer_t *) _FLU_INDEXER(cnt))

Boolean fluIndexerInit( struct flu_indexer_t *fi,
    flu_indexer_printerror_t printError, flu_indexer_memfail_t memoryFail,
    const char *tempDir, void *info);
void fluIndexerFree( struct flu_indexer_t *fi );

Boolean fluIndexerAddStopWords( struct flu_indexer_t *fi,
    const char **wordList, unsigned int count);
Boolean fluIndexerAddValidWords( struct flu_indexer_t *fi,
    const char **wordList, unsigned int count);

#define fifReindexOlders               0x0001u
#define fifReindexLasts                0x0002u
#define fifReindexAll                  0x0004u
#define fifUrlSafe                     0x0008u
#define fifIgnoreIndexInfo             0x0010u
#define fifIgnoreStopWords             0x0020u
#define fifInfoSafe                    0x0040u

Boolean fluIndexerDocumentStart( struct flu_indexer_t *fi,
    const char *url, zoff_t size, ztime_t lastModified, unsigned int flags);
Boolean fluIndexerDocumentEnd( struct flu_indexer_t *fi, Boolean success,
    unsigned zint_t *pwordCount);

Boolean fluIndexerSetContent( struct flu_indexer_t *fi, const char *title,
    const char *content, Boolean allContent);
Boolean fluIndexerDocumentAlive( struct flu_indexer_t *fi );

Boolean fluIndexerSetSwapCount( struct flu_indexer_t *fi, int count,
    unsigned zint_t maxMemoryVolum);
Boolean fluIndexerReadyForSwapping( struct flu_indexer_t *fi, Boolean final);
Boolean fluIndexerSwapping( struct flu_indexer_t *fi, Boolean final);

Boolean fluIndexerAddIndexFile( struct flu_indexer_t *fi,
    const char *fileName, unsigned int flags);
Boolean fluIndexerAddWord( struct flu_indexer_t *fi, const char *word,
    int emphasized, _st_t structure);

typedef Boolean (*flu_indexer_checkword_t)( struct flu_indexer_t *, const char *, unsigned int);
typedef void (*flu_indexer_tracer_t)( struct flu_indexer_t *, int, unsigned zint_t);

enum
{
#if defined( FLUIDS43 )
  fisStepStartDirlist,
  fisStepEndDirlist,
#endif
  fisStepDocGeneral,
  fisStepSkipDocs,
  fisStepStartWordlist,
  fisStepEndWordlist,
  fisStepSkipWords,
  fisStepStopWords,
  fisStepStartDoclist,
  fisStepEndDoclist,
};

Boolean fluIndexerOpen( struct flu_indexer_t *fi, const char *fileName,
    const char *alias, const char *indexName, const char *indexDescription,
    const char *indexPointer, const char *indexAdmin, unsigned int flags);
Boolean fluIndexerClose( struct flu_indexer_t *fi,
    flu_indexer_checkword_t checkWord,
    flu_indexer_tracer_t tracer, unsigned int flags);

#ifdef __cplusplus
}
#endif

#endif
