/*
    FLUIdS - local search system
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstring.h" /* <string.h> */

#include "error.h"

ZDEF(const char * const) fluErrorEnglishFormats[] =
{
  /* errNoError                      */ "",
  /* errProgParams                   */ "",
  /* errDifferentCharset             */ "The index file \"%.1000s\" has inappropriate charset.",
  /* errIndexFileFormat              */ "Invalid format of the index file \"%.1000s\".",
  /* errIndexFileOpen                */ "Cann't open the index file \"%.1000s\": %.100s",
  /* errIndexFileSeek                */ "Fseek function failed for the index file \"%.1000s\": %.100s",
  /* errIndexFileTell                */ "Ftell function failed for the index file \"%.1000s\": %.100s",
  /* errIndexFileVersion             */ "Unsupported version of the index file \"%.1000s\".",
  /* errIndexFileSize                */ "The size of the index file \"%.1000s\" is less than specified in the header.",
  /* errIndexFileId                  */ "The file \"%.1000s\" is not FLUIdS index file.",
  /* errIndexChecksum                */ "Bad checksum of the header of the index file \"%.1000s\".",
  /* errIndexFileCount               */ "Number of indexed files into the index file \"%.1000s\" exceeds the limit.",
  /* errIndexFileOffsetsCount        */ "Number of file offsets in the index file \"%.1000s\" is inconsistent with number of indexed files specified in the header.",
  /* errIndexFileStructuresCount     */ "Number of file structures in the index file \"%.1000s\" is inconsistent with number of indexed files specified in the header.",
  /* errIndexFileOffsets             */ "Invalid file offsets in the index file \"%.1000s\".",
  /* errIndexWordTrackSize           */ "The word track size in the index file \"%.1000s\" is inconsistent with the size defined in the header.",
  /* errIndexWordTrackOffsets        */ "Invalid word track offsets in the index file \"%.1000s\".",
#ifdef CHECK
  /* errIndexOffsets                 */ "Invalid offsets in the header of the index file \"%.1000s\".",
#endif
  /* errIndexFileRead                */ "Cann't read the index file \"%.1000s\": %.100s",
#ifdef CHECK
  /* errIndexFileReadInfo            */ "Cann't read the info of index file \"%.1000s\": %.100s",
  /* errIndexFileReadStopWords       */ "Cann't read the stop words of index file \"%.1000s\": %.100s",
  /* errIndexFileReadValidWords      */ "Cann't read the short words of index file \"%.1000s\": %.100s",
  /* errIndexFileReadFileInfo        */ "Cann't read the file info of index file \"%.1000s\": %.100s",
#endif
  /* errIndexFileWrite               */ "Cann't write the index file \"%.1000s\": %.100s",
#ifdef CHECK
  /* errIndexFileWriteHeader         */ "Cann't write the header of index file \"%.1000s\": %.100s",
  /* errIndexFileWriteInfo           */ "Cann't write the info of index file \"%.1000s\": %.100s",
  /* errIndexFileWriteStopWords      */ "Cann't write the stop words of index file \"%.1000s\": %.100s",
  /* errIndexFileWriteValidWords     */ "Cann't write the valid words of index file \"%.1000s\": %.100s",
  /* errIndexFileWriteFileOffsets    */ "Cann't write the file offsets of the index file \"%.1000s\": %.100s",
  /* errIndexFileWriteFileStructures */ "Cann't write the file structures of the index file \"%.1000s\": %.100s",
  /* errIndexFileWriteFileInfo       */ "Cann't write the index file info of \"%.1000s\": %.100s",
#endif
  /* errIndexFileOverlappingNames    */ "Index file names conflict.",
  /* errInvalidFilenoValue           */ "Invalid file number (%u) in \"%.100s\".",
  /* errNoSuchDocument               */ "No such document \"%.1000s\" in the index file \"%.1000\".",
  /* errNoQuery                      */ "No search words specified",
  /* errQuote                        */ "Matching \" is absent",
  /* errBlankQuotedString            */ "No search words specified inside \"\"",
  /* errClosingParanthis             */ "Unnecessary ) is present",
  /* errNoReasonableQuery            */ "No reasonable query specified",
  /* errStopWord                     */ "The search word '%s' is too common",
  /* errShortWord                    */ "The search word '%s' is too small",
  /* errLongWord                     */ "The search word '%s' is too long",
  /* errBeginChar                    */ "The search word cann't begin with '%c' [%s]",
  /* errEndChar                      */ "The search word cann't end with '%c' [%s]",
  /*                                 */ NULL
};
