/*
    FLUIdS - local search system
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstring.h" /* <string.h> */

#include "zcontext.h"
#include "zerror.h"
#include "zstdio.h"

#include "fludata.h"
#include "error.h"

ZFUN(char *) fluGetErrorString( struct zcontext_t *cnt, char *buffer, int size,
    unsigned zint_t errorCode, const char *name)
{
  int errc = _zErrorCode( errorCode );
  const char * const *formats = FLU(cnt)->errorFormats;
  char errbuf[100];

  if( zCheckFlags( errorCode, zefGeneral) )
    (void) zGetErrorString( cnt, buffer, size, errorCode, name);
  else
    switch( errc )
    {
      case errProgParams:
        zsprintf( buffer, size, "%s", name);
        break;

      case errDifferentCharset:
	zsprintf( buffer, size, formats[errc], name);
	break;

      case errIndexFileOverlappingNames:
	zsprintf( buffer, size, formats[errc]);
        break;

      case errIndexFileFormat:
        zsprintf( buffer, size, formats[errc], name == NULL ? "" : name);
        break;

      case errIndexFileOpen:
      case errIndexFileSeek:
      case errIndexFileTell:
      case errIndexFileRead:
#ifdef CHECK
      case errIndexFileReadInfo:
      case errIndexFileReadStopWords:
      case errIndexFileReadValidWords:
      case errIndexFileReadFileInfo:
#endif
      case errIndexFileWrite:
#ifdef CHECK
      case errIndexFileWriteHeader:
      case errIndexFileWriteInfo:
      case errIndexFileWriteStopWords:
      case errIndexFileWriteValidWords:
      case errIndexFileWriteFileOffsets:
      case errIndexFileWriteFileStructures:
      case errIndexFileWriteFileInfo:
#endif
        zsprintf( buffer, size, formats[errc], name,
	  zSystemErrorString( errorCode, errbuf, sizeof( errbuf )));
	break;

      case errIndexFileVersion:
      case errIndexFileSize:
      case errIndexFileId:
      case errIndexChecksum:
      case errIndexFileCount:
      case errIndexFileOffsetsCount:
      case errIndexFileStructuresCount:
      case errIndexFileOffsets:
      case errIndexWordTrackSize:
      case errIndexWordTrackOffsets:
#ifdef CHECK
      case errIndexOffsets:
#endif
        zsprintf( buffer, size, formats[errc], name);
	break;

      case errInvalidFilenoValue:
        zsprintf( buffer, size, formats[errc], (unsigned int) cnt->errorIntParam, name);
	break;

      case errNoSuchDocument:
        zsprintf( buffer, size, formats[errc], name, cnt->errorStrParam);
	break;

      case errNoQuery:
      case errQuote:
      case errBlankQuotedString:
      case errClosingParanthis:
      case errNoReasonableQuery:
        zsprintf( buffer, size, formats[errc]);
        break;

      case errStopWord:
      case errShortWord:
      case errLongWord:
        zsprintf( buffer, size, formats[errc], name);
        break;

#ifdef BEGIN_WORD_CHAR_BITS
      case errBeginChar:
        zsprintf( buffer, size, formats[errc], *name, name);
        break;
#endif

#ifdef END_WORD_CHAR_BITS
      case errEndChar:
        zsprintf( buffer, size, formats[errc], name[strlen(name)-1], name);
        break;
#endif

      default:
        zsprintf( buffer, size, "??? (%d)", errc);
	break;
  }

  return buffer;
}
